/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Testable;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Steerable;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.LlamaInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Equip")
@Description(value={"Equips an entity with some given armor. This will replace any armor that the entity is wearing."})
@Examples(value={"equip player with diamond helmet", "equip player with all diamond armor"})
@Since(value="1.0")
public class EffEquip
extends Effect
implements Testable {
    private Expression<LivingEntity> entities;
    private Expression<ItemType> types;
    private static final boolean SUPPORTS_HORSES;
    private static final boolean NEW_HORSES;
    private static final boolean SUPPORTS_LLAMAS;
    private static final boolean SUPPORTS_STEERABLE;
    private static final ItemType HELMET;
    private static final ItemType CHESTPLATE;
    private static final ItemType LEGGINGS;
    private static final ItemType BOOTS;
    private static final ItemType HORSE_ARMOR;
    private static final ItemType SADDLE;
    private static final ItemType CHEST;
    private static final ItemType CARPET;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.types = vars[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        ItemType[] ts = this.types.getArray(e);
        block0: for (LivingEntity en : this.entities.getArray(e)) {
            EntityEquipment equip;
            if (SUPPORTS_STEERABLE && en instanceof Steerable) {
                for (ItemType it : ts) {
                    if (!SADDLE.isOfType(it.getMaterial())) continue;
                    ((Steerable)en).setSaddle(true);
                }
            } else {
                LlamaInventory invi;
                if (en instanceof Pig) {
                    for (ItemType t : ts) {
                        if (!t.isOfType(Material.SADDLE)) continue;
                        ((Pig)en).setSaddle(true);
                        continue block0;
                    }
                    continue;
                }
                if (SUPPORTS_LLAMAS && en instanceof Llama) {
                    invi = ((Llama)en).getInventory();
                    for (ItemType t : ts) {
                        for (ItemStack item : t.getAll()) {
                            if (CARPET.isOfType(item)) {
                                invi.setDecor(item);
                                continue;
                            }
                            if (!CHEST.isOfType(item)) continue;
                            ((Llama)en).setCarryingChest(true);
                        }
                    }
                    continue;
                }
                if (NEW_HORSES && en instanceof AbstractHorse) {
                    invi = ((AbstractHorse)en).getInventory();
                    for (ItemType t : ts) {
                        for (ItemStack item : t.getAll()) {
                            if (SADDLE.isOfType(item)) {
                                invi.setItem(0, item);
                                continue;
                            }
                            if (HORSE_ARMOR.isOfType(item)) {
                                invi.setItem(1, item);
                                continue;
                            }
                            if (!CHEST.isOfType(item) || !(en instanceof ChestedHorse)) continue;
                            ((ChestedHorse)en).setCarryingChest(true);
                        }
                    }
                    continue;
                }
                if (SUPPORTS_HORSES && en instanceof Horse) {
                    invi = ((Horse)en).getInventory();
                    for (ItemType t : ts) {
                        for (ItemStack item : t.getAll()) {
                            if (SADDLE.isOfType(item)) {
                                invi.setSaddle(item);
                                continue;
                            }
                            if (HORSE_ARMOR.isOfType(item)) {
                                invi.setArmor(item);
                                continue;
                            }
                            if (!CHEST.isOfType(item)) continue;
                            ((Horse)en).setCarryingChest(true);
                        }
                    }
                    continue;
                }
            }
            if ((equip = en.getEquipment()) == null) continue;
            for (ItemType t : ts) {
                for (ItemStack item : t.getAll()) {
                    if (HELMET.isOfType(item) || item.getType().isBlock()) {
                        equip.setHelmet(item);
                        continue;
                    }
                    if (CHESTPLATE.isOfType(item)) {
                        equip.setChestplate(item);
                        continue;
                    }
                    if (LEGGINGS.isOfType(item)) {
                        equip.setLeggings(item);
                        continue;
                    }
                    if (!BOOTS.isOfType(item)) continue;
                    equip.setBoots(item);
                }
            }
            if (!(en instanceof Player)) continue;
            PlayerUtils.updateInventory((Player)en);
        }
    }

    @Override
    public boolean test(Event e) {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "equip " + this.entities.toString(e, debug) + " with " + this.types.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEquip.class, "equip [%livingentity%] with %itemtypes%", "make %livingentity% wear %itemtypes%");
        SUPPORTS_HORSES = Skript.classExists("org.bukkit.entity.Horse");
        NEW_HORSES = Skript.classExists("org.bukkit.entity.AbstractHorse");
        SUPPORTS_LLAMAS = Skript.classExists("org.bukkit.entity.Llama");
        SUPPORTS_STEERABLE = Skript.classExists("org.bukkit.entity.Steerable");
        HELMET = Aliases.javaItemType("helmet");
        CHESTPLATE = Aliases.javaItemType("chestplate");
        LEGGINGS = Aliases.javaItemType("leggings");
        BOOTS = Aliases.javaItemType("boots");
        HORSE_ARMOR = Aliases.javaItemType("horse armor");
        SADDLE = Aliases.javaItemType("saddle");
        CHEST = Aliases.javaItemType("chest");
        CARPET = Aliases.javaItemType("carpet");
    }
}

