/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.sections.SecConditional;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.sections.SecWhile;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Exit")
@Description(value={"Exits a given amount of loops and conditionals, or the entire trigger."})
@Examples(value={"if player has any ore:", "\tstop", "message \"%player% has no ores!\"", "loop blocks above the player:", "\tloop-block is not air:", "\t\texit 2 sections", "\tset loop-block to water"})
@Since(value="<i>unknown</i> (before 2.1)")
public class EffExit
extends Effect {
    private int breakLevels;
    private static final int EVERYTHING = 0;
    private static final int LOOPS = 1;
    private static final int CONDITIONALS = 2;
    private static final String[] names;
    private int type;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.breakLevels = this.getParser().getCurrentSections().size() + 1;
                this.type = 0;
                break;
            }
            case 1: 
            case 2: {
                this.breakLevels = matchedPattern == 1 ? 1 : Integer.parseInt(parser.regexes.get(0).group());
                this.type = parser.mark;
                if (this.breakLevels <= EffExit.numLevels(this.type)) break;
                if (EffExit.numLevels(this.type) == 0) {
                    Skript.error("can't stop any " + names[this.type] + " as there are no " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("can't stop " + this.breakLevels + " " + names[this.type] + " as there are only " + EffExit.numLevels(this.type) + " " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            case 3: {
                this.type = parser.mark;
                this.breakLevels = EffExit.numLevels(this.type);
                if (this.breakLevels != 0) break;
                Skript.error("can't stop any " + names[this.type] + " as there are no " + names[this.type] + " present", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
        }
        return true;
    }

    private static int numLevels(int type) {
        List<TriggerSection> currentSections = ParserInstance.get().getCurrentSections();
        if (type == 0) {
            return currentSections.size();
        }
        int r = 0;
        for (TriggerSection s : currentSections) {
            if (!(type == 2 ? s instanceof SecConditional : s instanceof SecLoop || s instanceof SecWhile)) continue;
            ++r;
        }
        return r;
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        this.debug(e, false);
        TriggerItem n = this;
        int i = this.breakLevels;
        while (i > 0) {
            if ((n = n.getParent()) == null) {
                assert (false) : this;
                return null;
            }
            if (n instanceof SecLoop) {
                ((SecLoop)n).exit(e);
            } else if (n instanceof SecWhile) {
                ((SecWhile)n).reset();
            }
            if (this.type != 0 && (this.type != 2 || !(n instanceof SecConditional)) && (this.type != 1 || !(n instanceof SecLoop) && !(n instanceof SecWhile))) continue;
            --i;
        }
        return n instanceof SecLoop ? ((SecLoop)n).getActualNext() : (n instanceof SecWhile ? ((SecWhile)n).getActualNext() : n.getNext());
    }

    @Override
    protected void execute(Event e) {
        assert (false);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "stop " + this.breakLevels + " " + names[this.type];
    }

    static {
        Skript.registerEffect(EffExit.class, "(exit|stop) [trigger]", "(exit|stop) [(1|a|the|this)] (0\u00a6section|1\u00a6loop|2\u00a6conditional)", "(exit|stop) <\\d+> (0\u00a6section|1\u00a6loop|2\u00a6conditional)s", "(exit|stop) all (0\u00a6section|1\u00a6loop|2\u00a6conditional)s");
        names = new String[]{"sections", "loops", "conditionals"};
    }
}

