/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Open/Close Inventory")
@Description(value={"Opens an inventory to a player. The player can then access and modify the inventory as if it was a chest that he just opened.", "Please note that currently 'show' and 'open' have the same effect, but 'show' will eventually show an unmodifiable view of the inventory in the future."})
@Examples(value={"show the victim's inventory to the player", "open the player's inventory for the player"})
@Since(value="2.0, 2.1.1 (closing), 2.2-Fixes-V10 (anvil), 2.4 (hopper, dropper, dispenser")
public class EffOpenInventory
extends Effect {
    private static final int WORKBENCH = 0;
    private static final int CHEST = 1;
    private static final int ANVIL = 2;
    private static final int HOPPER = 3;
    private static final int DROPPER = 4;
    private static final int DISPENSER = 5;
    private @Nullable Expression<?> invi;
    boolean open;
    private int invType;
    private Expression<Player> players;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int openFlag = 0;
        if (parseResult.mark >= 5) {
            openFlag = parseResult.mark ^ 5;
            this.invType = 5;
        } else if (parseResult.mark >= 4) {
            openFlag = parseResult.mark ^ 4;
            this.invType = 4;
        } else if (parseResult.mark >= 3) {
            openFlag = parseResult.mark ^ 3;
            this.invType = 3;
        } else if (parseResult.mark >= 2) {
            openFlag = parseResult.mark ^ 2;
            this.invType = 2;
        } else if (parseResult.mark >= 1) {
            openFlag = parseResult.mark ^ 1;
            this.invType = 1;
        } else if (parseResult.mark >= 0) {
            this.invType = 0;
            openFlag = parseResult.mark ^ 0;
        } else {
            openFlag = parseResult.mark;
        }
        this.open = matchedPattern == 0;
        this.invi = this.open ? exprs[0] : null;
        this.players = exprs[exprs.length - 1];
        if (openFlag == 1 && this.invi != null) {
            Skript.warning("Using 'show' inventory instead of 'open' is not recommended as it will eventually show an unmodifiable view of the inventory in the future.");
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.invi != null) {
            Inventory i;
            assert (this.invi != null);
            Object o = this.invi.getSingle(e);
            if (o instanceof Inventory) {
                i = (Inventory)o;
            } else if (o instanceof InventoryType) {
                i = Bukkit.createInventory(null, (InventoryType)((InventoryType)o));
            } else {
                return;
            }
            if (i == null) {
                return;
            }
            for (Player p : this.players.getArray(e)) {
                try {
                    p.openInventory(i);
                }
                catch (IllegalArgumentException ex) {
                    Skript.error("You can't open a " + i.getType().name().toLowerCase(Locale.ENGLISH).replaceAll("_", "") + " inventory to a player.");
                }
            }
        } else {
            for (Player p : this.players.getArray(e)) {
                if (this.open) {
                    switch (this.invType) {
                        case 0: {
                            p.openWorkbench(null, true);
                            break;
                        }
                        case 1: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.CHEST));
                            break;
                        }
                        case 2: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.ANVIL));
                            break;
                        }
                        case 3: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.HOPPER));
                            break;
                        }
                        case 4: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.DROPPER));
                            break;
                        }
                        case 5: {
                            p.openInventory(Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.DISPENSER));
                        }
                    }
                    continue;
                }
                p.closeInventory();
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.open ? "open " + (this.invi != null ? this.invi.toString(e, debug) : "crafting table") + " to " : "close inventory view of ") + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenInventory.class, "(open|show) ((0\u00a6(crafting [table]|workbench)|1\u00a6chest|2\u00a6anvil|3\u00a6hopper|4\u00a6dropper|5\u00a6dispenser) (view|window|inventory|)|%-inventory/inventorytype%) (to|for) %players%", "close [the] inventory [view] (to|of|for) %players%", "close %players%'[s] inventory [view]");
    }
}

