/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public class FallingBlockData
extends EntityData<FallingBlock> {
    private static final Message m_not_a_block_error;
    private static final Adjective m_adjective;
    private @Nullable ItemType[] types = null;

    public FallingBlockData() {
    }

    public FallingBlockData(@Nullable ItemType[] types) {
        this.types = types;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length > 0 && exprs[0] != null) {
            this.types = Converters.convert((ItemType[])exprs[0].getAll(), ItemType.class, new Converter<ItemType, ItemType>(){

                @Override
                public @Nullable ItemType convert(ItemType t) {
                    t = t.getBlock().clone();
                    Iterator<ItemData> iter = t.iterator();
                    while (iter.hasNext()) {
                        Material id = iter.next().getType();
                        if (id.isBlock()) continue;
                        iter.remove();
                    }
                    if (t.numTypes() == 0) {
                        return null;
                    }
                    t.setAmount(-1);
                    t.setAll(false);
                    t.clearEnchantments();
                    return t;
                }
            });
            if (this.types.length == 0) {
                Skript.error(m_not_a_block_error.toString());
                return false;
            }
        } else {
            this.types = new ItemType[]{new ItemType(Material.STONE)};
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends FallingBlock> c, @Nullable FallingBlock e) {
        if (e != null) {
            this.types = new ItemType[]{new ItemType(BlockCompat.INSTANCE.fallingBlockToState(e))};
        }
        return true;
    }

    @Override
    protected boolean match(FallingBlock entity) {
        if (this.types != null) {
            for (ItemType t : this.types) {
                if (!t.isOfType(BlockCompat.INSTANCE.fallingBlockToState(entity))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public @Nullable FallingBlock spawn(Location loc, @Nullable Consumer<FallingBlock> consumer) {
        ItemType t = CollectionUtils.getRandom(this.types);
        assert (t != null);
        Material material = t.getMaterial();
        if (!material.isBlock()) {
            assert (false) : t;
            return null;
        }
        FallingBlock fallingBlock = loc.getWorld().spawnFallingBlock(loc, material.createBlockData());
        if (consumer != null) {
            consumer.accept((Object)fallingBlock);
        }
        return fallingBlock;
    }

    @Override
    public void set(FallingBlock entity) {
        assert (false);
    }

    @Override
    public Class<? extends FallingBlock> getType() {
        return FallingBlock.class;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof FallingBlockData)) {
            return false;
        }
        FallingBlockData d = (FallingBlockData)e;
        if (this.types != null) {
            if (d.types != null) {
                return ItemType.isSubset(this.types, d.types);
            }
            return false;
        }
        return true;
    }

    @Override
    public EntityData getSuperType() {
        return new FallingBlockData(this.types);
    }

    @Override
    public String toString(int flags) {
        Object[] types = this.types;
        if (types == null) {
            return super.toString(flags);
        }
        StringBuilder b = new StringBuilder();
        b.append(Noun.getArticleWithSpace(types[0].getTypes().get(0).getGender(), flags));
        b.append(m_adjective.toString(types[0].getTypes().get(0).getGender(), flags));
        b.append(" ");
        b.append(Classes.toString(types, flags & 0xFFFFFFF9, false));
        return "" + b.toString();
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        throw new UnsupportedOperationException("old serialization is not supported");
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof FallingBlockData)) {
            return false;
        }
        return Arrays.equals(this.types, ((FallingBlockData)obj).types);
    }

    @Override
    protected int hashCode_i() {
        return Arrays.hashCode(this.types);
    }

    static {
        EntityData.register(FallingBlockData.class, "falling block", FallingBlock.class, "falling block");
        m_not_a_block_error = new Message("entities.falling block.not a block error");
        m_adjective = new Adjective("entities.falling block.adjective");
    }
}

