/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public class ThrownPotionData
extends EntityData<ThrownPotion> {
    private static final Adjective m_adjective;
    private static final boolean RUNNING_LEGACY;
    private static final boolean LINGERING_POTION_ENTITY_USED;
    private static final Class<? extends ThrownPotion> LINGERING_POTION_ENTITY_CLASS;
    private static final ItemType POTION;
    private static final ItemType SPLASH_POTION;
    private static final ItemType LINGER_POTION;
    private @Nullable ItemType[] types;

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length > 0 && exprs[0] != null) {
            this.types = Converters.convert((ItemType[])exprs[0].getAll(), ItemType.class, t -> {
                if (t.isSupertypeOf(POTION) || t.isSupertypeOf(LINGER_POTION) && RUNNING_LEGACY) {
                    ItemMeta meta = t.getItemMeta();
                    ItemType itemType = SPLASH_POTION.clone();
                    itemType.setItemMeta(meta);
                    return itemType;
                }
                if (!t.isSupertypeOf(SPLASH_POTION) && !t.isSupertypeOf(LINGER_POTION)) {
                    return null;
                }
                return t;
            });
            return this.types.length != 0;
        }
        this.types = new ItemType[]{SPLASH_POTION.clone()};
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends ThrownPotion> c, @Nullable ThrownPotion e) {
        if (e != null) {
            ItemStack i = e.getItem();
            this.types = new ItemType[]{new ItemType(i)};
        }
        return true;
    }

    @Override
    protected boolean match(ThrownPotion entity) {
        if (this.types != null) {
            for (ItemType t : this.types) {
                if (!t.isOfType(entity.getItem())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public @Nullable ThrownPotion spawn(Location loc, @Nullable Consumer<ThrownPotion> consumer) {
        ItemType t = CollectionUtils.getRandom(this.types);
        assert (t != null);
        ItemStack i = t.getRandom();
        if (i == null) {
            return null;
        }
        Class<? extends ThrownPotion> thrownPotionClass = LINGER_POTION.isOfType(i) ? LINGERING_POTION_ENTITY_CLASS : ThrownPotion.class;
        ThrownPotion potion = consumer != null ? (ThrownPotion)loc.getWorld().spawn(loc, thrownPotionClass, consumer) : (ThrownPotion)loc.getWorld().spawn(loc, thrownPotionClass);
        potion.setItem(i);
        return potion;
    }

    @Override
    public void set(ThrownPotion entity) {
        if (this.types != null) {
            ItemType t = CollectionUtils.getRandom(this.types);
            assert (t != null);
            ItemStack i = t.getRandom();
            if (i == null) {
                return;
            }
            if (LINGERING_POTION_ENTITY_USED && LINGERING_POTION_ENTITY_CLASS.isInstance(entity) != LINGER_POTION.isOfType(i)) {
                return;
            }
            entity.setItem(i);
        }
        assert (false);
    }

    @Override
    public Class<? extends ThrownPotion> getType() {
        return ThrownPotion.class;
    }

    @Override
    public EntityData getSuperType() {
        return new ThrownPotionData();
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof ThrownPotionData)) {
            return false;
        }
        ThrownPotionData d = (ThrownPotionData)e;
        if (this.types != null) {
            return d.types != null && ItemType.isSubset(this.types, d.types);
        }
        return true;
    }

    @Override
    public String toString(int flags) {
        Object[] types = this.types;
        if (types == null) {
            return super.toString(flags);
        }
        StringBuilder b = new StringBuilder();
        b.append(Noun.getArticleWithSpace(types[0].getTypes().get(0).getGender(), flags));
        b.append(m_adjective.toString(types[0].getTypes().get(0).getGender(), flags));
        b.append(" ");
        b.append(Classes.toString(types, flags & 0xFFFFFFF9, false));
        return "" + b.toString();
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        throw new UnsupportedOperationException("old serialization is no longer supported");
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof ThrownPotionData)) {
            return false;
        }
        return Arrays.equals(this.types, ((ThrownPotionData)obj).types);
    }

    @Override
    protected int hashCode_i() {
        return Arrays.hashCode(this.types);
    }

    static {
        EntityData.register(ThrownPotionData.class, "thrown potion", ThrownPotion.class, "thrown potion");
        m_adjective = new Adjective("entities.thrown potion.adjective");
        RUNNING_LEGACY = !Skript.isRunningMinecraft(1, 13);
        LINGERING_POTION_ENTITY_USED = !Skript.isRunningMinecraft(1, 14);
        LINGERING_POTION_ENTITY_CLASS = LINGERING_POTION_ENTITY_USED ? LingeringPotion.class : ThrownPotion.class;
        POTION = Aliases.javaItemType("potion");
        SPLASH_POTION = Aliases.javaItemType("splash potion");
        LINGER_POTION = Aliases.javaItemType("lingering potion");
    }
}

