/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtBlock
extends SkriptEvent {
    private @Nullable Literal<Object> types;
    private boolean mine = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        this.mine = parser.mark == 1;
        return true;
    }

    @Override
    public boolean check(Event e) {
        ItemType item;
        if (this.mine && e instanceof BlockBreakEvent && ((BlockBreakEvent)e).getBlock().getDrops(((BlockBreakEvent)e).getPlayer().getItemInHand()).isEmpty()) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        BlockData blockData = null;
        if (e instanceof BlockFormEvent) {
            BlockFormEvent blockFormEvent = (BlockFormEvent)e;
            BlockState newState = blockFormEvent.getNewState();
            item = new ItemType(newState);
            blockData = newState.getBlockData();
        } else if (e instanceof BlockEvent) {
            BlockEvent blockEvent = (BlockEvent)e;
            Block block = blockEvent.getBlock();
            item = new ItemType(block);
            blockData = block.getBlockData();
        } else if (e instanceof PlayerBucketFillEvent) {
            PlayerBucketFillEvent playerBucketFillEvent = (PlayerBucketFillEvent)e;
            Block relative = playerBucketFillEvent.getBlockClicked().getRelative(playerBucketFillEvent.getBlockFace());
            item = new ItemType(relative);
            blockData = relative.getBlockData();
        } else if (e instanceof PlayerBucketEmptyEvent) {
            PlayerBucketEmptyEvent playerBucketEmptyEvent = (PlayerBucketEmptyEvent)e;
            item = new ItemType(playerBucketEmptyEvent.getItemStack());
        } else {
            if (e instanceof HangingEvent) {
                EntityData<Hanging> d = EntityData.fromEntity(((HangingEvent)e).getEntity());
                return this.types.check(e, o -> {
                    if (o instanceof ItemType) {
                        return Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(d, (ItemType)o));
                    }
                    return false;
                });
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        ItemType itemF = item;
        BlockData finalBlockData = blockData;
        return this.types.check(e, o -> {
            if (o instanceof ItemType) {
                return ((ItemType)o).isSupertypeOf(itemF);
            }
            if (o instanceof BlockData && finalBlockData != null) {
                return finalBlockData.matches((BlockData)o);
            }
            return false;
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "break/place/burn/fade/form of " + Classes.toString(this.types);
    }

    static {
        boolean bl = $assertionsDisabled = !EvtBlock.class.desiredAssertionStatus();
        if (Skript.isRunningMinecraft(1, 13)) {
            Skript.registerEvent("Break / Mine", EvtBlock.class, new Class[]{BlockBreakEvent.class, PlayerBucketFillEvent.class, HangingBreakEvent.class}, "[block] (break[ing]|1\u00a6min(e|ing)) [[of] %itemtypes/blockdatas%]").description("Called when a block is broken by a player. If you use 'on mine', only events where the broken block dropped something will call the trigger.").examples("on mine:", "on break of stone:", "on mine of any ore:", "on break of chest[facing=north]:", "on break of potatoes[age=7]:").requiredPlugins("Minecraft 1.13+ (BlockData)").since("1.0 (break), <i>unknown</i> (mine), 2.6 (BlockData support)");
            Skript.registerEvent("Burn", EvtBlock.class, BlockBurnEvent.class, "[block] burn[ing] [[of] %itemtypes/blockdatas%]").description("Called when a block is destroyed by fire.").examples("on burn:", "on burn of wood, fences, or chests:", "on burn of oak_log[axis=y]:").requiredPlugins("Minecraft 1.13+ (BlockData)").since("1.0, 2.6 (BlockData support)");
            Skript.registerEvent("Place", EvtBlock.class, new Class[]{BlockPlaceEvent.class, PlayerBucketEmptyEvent.class, HangingPlaceEvent.class}, "[block] (plac(e|ing)|build[ing]) [[of] %itemtypes/blockdatas%]").description("Called when a player places a block.").examples("on place:", "on place of a furnace, workbench or chest:", "on break of chest[type=right] or chest[type=left]").requiredPlugins("Minecraft 1.13+ (BlockData)").since("1.0, 2.6 (BlockData support)");
            Skript.registerEvent("Fade", EvtBlock.class, BlockFadeEvent.class, "[block] fad(e|ing) [[of] %itemtypes/blockdatas%]").description("Called when a block 'fades away', e.g. ice or snow melts.").examples("on fade of snow or ice:", "on fade of snow[layers=2]").requiredPlugins("Minecraft 1.13+ (BlockData)").since("1.0, 2.6 (BlockData support)");
            Skript.registerEvent("Form", EvtBlock.class, BlockFormEvent.class, "[block] form[ing] [[of] %itemtypes/blockdatas%]").description("Called when a block is created, but not by a player, e.g. snow forms due to snowfall, water freezes in cold biomes. This isn't called when block spreads (mushroom growth, water physics etc.), as it has its own event (see <a href='#spread'>spread event</a>).").examples("on form of snow:", "on form of a mushroom:").requiredPlugins("Minecraft 1.13+ (BlockData)").since("1.0, 2.6 (BlockData support)");
        }
    }
}

