/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.StructureType;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtGrow
extends SkriptEvent {
    public static final int ANY = 0;
    public static final int STRUCTURE = 1;
    public static final int BLOCK = 2;
    private @Nullable Literal<StructureType> types;
    private @Nullable Literal<ItemType> blocks;
    private int evtType;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.evtType = parser.mark;
        if (this.evtType == 1) {
            this.types = args[0];
        } else if (this.evtType == 2) {
            this.blocks = args[1];
        }
        return true;
    }

    @Override
    public boolean check(final Event e) {
        if (this.evtType == 1 && this.types != null && e instanceof StructureGrowEvent) {
            return this.types.check(e, new Checker<StructureType>(){

                @Override
                public boolean check(StructureType t) {
                    return t.is(((StructureGrowEvent)e).getSpecies());
                }
            });
        }
        if (this.evtType == 2 && this.blocks != null && e instanceof BlockGrowEvent) {
            assert (this.blocks != null);
            return this.blocks.check(e, new Checker<ItemType>(){

                @Override
                public boolean check(ItemType t) {
                    return t.isOfType(((BlockGrowEvent)e).getBlock());
                }
            });
        }
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.evtType == 1) {
            return "grow" + (this.types != null ? " of " + this.types.toString(e, debug) : "");
        }
        if (this.evtType == 2) {
            return "grow" + (this.blocks != null ? " of " + this.blocks.toString(e, debug) : "");
        }
        return "grow";
    }

    static {
        Skript.registerEvent("Grow", EvtGrow.class, CollectionUtils.array(StructureGrowEvent.class, BlockGrowEvent.class), "grow [of (1\u00a6%-structuretype%|2\u00a6%-itemtype%)]").description("Called when a tree, giant mushroom or plant grows to next stage.").examples("on grow:", "on grow of a tree:", "on grow of a huge jungle tree:").since("1.0 (2.2-dev20 for plants)");
    }
}

