/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Command")
@Description(value={"The command that caused an 'on command' event (excluding the leading slash and all arguments)"})
@Examples(value={"# prevent any commands except for the /exit command during some game", "on command:", "\tif {game::%player%::playing} is true:", "\t\tif the command is not \"exit\":", "\t\t\tmessage \"You're not allowed to use commands during the game\"", "\t\t\tcancel the event"})
@Since(value="2.0")
@Events(value={"command"})
public class ExprCommand
extends SimpleExpression<String> {
    private static final int FULL = 0;
    private static final int LABEL = 1;
    private static final int ARGS = 2;
    private int what;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.what = matchedPattern;
        if (!this.getParser().isCurrentEvent(PlayerCommandPreprocessEvent.class, ServerCommandEvent.class)) {
            if (this.what != 2) {
                Skript.error("The 'command' expression can only be used in a command event");
            }
            return false;
        }
        return true;
    }

    protected @Nullable String[] get(Event e) {
        String s;
        if (e instanceof PlayerCommandPreprocessEvent) {
            s = ((PlayerCommandPreprocessEvent)e).getMessage().substring(1).trim();
        } else if (e instanceof ServerCommandEvent) {
            s = ((ServerCommandEvent)e).getCommand().trim();
        } else {
            return new String[0];
        }
        if (this.what == 0) {
            return new String[]{s};
        }
        int c = s.indexOf(32);
        if (this.what == 2) {
            if (c == -1) {
                return new String[0];
            }
            return new String[]{s.substring(c + 1).trim()};
        }
        assert (this.what == 1);
        return new String[]{c == -1 ? s : s.substring(0, c)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.what == 0 ? "the full command" : (this.what == 1 ? "the command" : "the arguments");
    }

    static {
        Skript.registerExpression(ExprCommand.class, String.class, ExpressionType.SIMPLE, "[the] (full|complete|whole) command", "[the] command [label]", "[the] arguments");
    }
}

