/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Command Info")
@Description(value={"Get information about a command."})
@Examples(value={"main name of command \"skript\"", "description of command \"help\"", "label of command \"pl\"", "usage of command \"help\"", "aliases of command \"bukkit:help\"", "permission of command \"/op\"", "command \"op\"'s permission message", "command \"sk\"'s plugin owner"})
@Since(value="2.6")
public class ExprCommandInfo
extends SimpleExpression<String> {
    InfoType type;
    Expression<String> commandName;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.commandName = exprs[0];
        this.type = InfoType.values()[Math.floorDiv(matchedPattern, 2)];
        return true;
    }

    protected @Nullable String[] get(Event e) {
        SimpleCommandMap map = Commands.getCommandMap();
        Command[] commands = (Command[])this.commandName.stream(e).map(arg_0 -> ((CommandMap)map).getCommand(arg_0)).filter(Objects::nonNull).toArray(Command[]::new);
        ArrayList<String> result = new ArrayList<String>();
        switch (this.type) {
            case NAME: {
                for (Command command : commands) {
                    result.add(command.getName());
                }
                break;
            }
            case DESCRIPTION: {
                for (Command command : commands) {
                    result.add(command.getDescription());
                }
                break;
            }
            case LABEL: {
                for (Command command : commands) {
                    result.add(command.getLabel());
                }
                break;
            }
            case USAGE: {
                for (Command command : commands) {
                    result.add(command.getUsage());
                }
                break;
            }
            case ALIASES: {
                for (Command command : commands) {
                    result.addAll(command.getAliases());
                }
                break;
            }
            case PERMISSION: {
                for (Command command : commands) {
                    result.add(command.getPermission());
                }
                break;
            }
            case PERMISSION_MESSAGE: {
                for (Command command : commands) {
                    result.add(command.getPermissionMessage());
                }
                break;
            }
            case PLUGIN: {
                for (Command command : commands) {
                    if (command instanceof PluginCommand) {
                        result.add(((PluginCommand)command).getPlugin().getName());
                        continue;
                    }
                    if (command instanceof BukkitCommand) {
                        result.add("Bukkit");
                        continue;
                    }
                    if (command.getClass().getPackage().getName().startsWith("org.spigot")) {
                        result.add("Spigot");
                        continue;
                    }
                    if (!command.getClass().getPackage().getName().startsWith("com.destroystokyo.paper")) continue;
                    result.add("Paper");
                }
                break;
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public boolean isSingle() {
        return this.type == InfoType.ALIASES || this.commandName.isSingle();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + this.type.name().toLowerCase(Locale.ENGLISH).replace("_", " ") + " of command " + this.commandName.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCommandInfo.class, String.class, ExpressionType.SIMPLE, "[the] main command [label] of command %strings%", "command %strings%'[s] main command [name]", "[the] description of command %strings%", "command %strings%'[s] description", "[the] label of command %strings%", "command %strings%'[s] label", "[the] usage of command %strings%", "command %strings%'[s] usage", "[(all|the|all [of] the)] aliases of command %strings%", "command %strings%'[s] aliases", "[the] permission of command %strings%", "command %strings%'[s] permission", "[the] permission message of command %strings%", "command %strings%'[s] permission message", "[the] plugin [owner] of command %strings%", "command %strings%'[s] plugin [owner]");
    }

    private static enum InfoType {
        NAME,
        DESCRIPTION,
        LABEL,
        USAGE,
        ALIASES,
        PERMISSION,
        PERMISSION_MESSAGE,
        PLUGIN;

    }
}

