/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Distance")
@Description(value={"The distance between two points."})
@Examples(value={"if the distance between the player and {home::%uuid of player%} is smaller than 20:", "\tmessage \"You're very close to your home!\""})
@Since(value="1.0")
public class ExprDistance
extends SimpleExpression<Number> {
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.loc1 = vars[0];
        this.loc2 = vars[1];
        return true;
    }

    protected @Nullable Number[] get(Event e) {
        Location l1 = this.loc1.getSingle(e);
        Location l2 = this.loc2.getSingle(e);
        if (l1 == null || l2 == null || l1.getWorld() != l2.getWorld()) {
            return new Number[0];
        }
        return new Number[]{l1.distance(l2)};
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "distance between " + this.loc1.toString(e, debug) + " and " + this.loc2.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        Skript.registerExpression(ExprDistance.class, Number.class, ExpressionType.COMBINED, "[the] distance between %location% and %location%");
    }
}

