/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.stream.Stream;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Entity Attribute")
@Description(value={"The numerical value of an entity's particular attribute.", "Note that the movement speed attribute cannot be reliably used for players. For that purpose, use the speed expression instead.", "Resetting an entity's attribute is only available in Minecraft 1.11 and above."})
@Examples(value={"on damage of player:", "\tsend \"You are wounded!\"", "\tset victim's attack speed attribute to 2"})
@Since(value="2.5, 2.6.1 (final attribute value)")
public class ExprEntityAttribute
extends PropertyExpression<Entity, Number> {
    private static final boolean DEFAULTVALUE_EXISTS;
    private @Nullable Expression<Attribute> attributes;
    private boolean withModifiers;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.attributes = exprs[matchedPattern];
        this.setExpr(exprs[matchedPattern ^ 1]);
        this.withModifiers = parseResult.mark == 1;
        return true;
    }

    protected Number[] get(Event e, Entity[] entities) {
        Attribute a = this.attributes.getSingle(e);
        return (Number[])Stream.of(entities).map(ent -> ExprEntityAttribute.getAttribute(ent, a)).map(att -> this.withModifiers ? att.getValue() : att.getBaseValue()).toArray(Number[]::new);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET && !DEFAULTVALUE_EXISTS || this.withModifiers) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Attribute a = this.attributes.getSingle(e);
        double d = delta == null ? 0.0 : ((Number)delta[0]).doubleValue();
        block8: for (Entity entity : (Entity[])this.getExpr().getArray(e)) {
            AttributeInstance ai = ExprEntityAttribute.getAttribute(entity, a);
            if (ai == null) continue;
            switch (mode) {
                case ADD: {
                    ai.setBaseValue(ai.getBaseValue() + d);
                    continue block8;
                }
                case SET: {
                    ai.setBaseValue(d);
                    continue block8;
                }
                case DELETE: {
                    ai.setBaseValue(0.0);
                    continue block8;
                }
                case RESET: {
                    ai.setBaseValue(ai.getDefaultValue());
                    continue block8;
                }
                case REMOVE: {
                    ai.setBaseValue(ai.getBaseValue() - d);
                    continue block8;
                }
                case REMOVE_ALL: {
                    assert (false);
                    continue block8;
                }
            }
        }
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "entity " + this.getExpr().toString(e, debug) + "'s " + (this.attributes == null ? "" : this.attributes.toString(e, debug)) + "attribute";
    }

    private static @Nullable AttributeInstance getAttribute(Entity e, @Nullable Attribute a) {
        if (a != null && e instanceof Attributable) {
            return ((Attributable)e).getAttribute(a);
        }
        return null;
    }

    static {
        Skript.registerExpression(ExprEntityAttribute.class, Number.class, ExpressionType.COMBINED, "[the] %attributetype% [(1\u00a6(total|final|modified))] attribute [value] of %entities%", "%entities%'[s] %attributetype% [(1\u00a6(total|final|modified))] attribute [value]");
        DEFAULTVALUE_EXISTS = Skript.isRunningMinecraft(1, 11);
    }
}

