/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hidden Players")
@Description(value={"The players hidden from a player that were hidden using the <a href='effects.html#EffPlayerVisibility'>player visibility</a> effect."})
@Examples(value={"message \"&lt;light red&gt;You are currently hiding: &lt;light gray&gt;%hidden players of the player%\""})
@Since(value="2.3")
public class ExprHiddenPlayers
extends SimpleExpression<Player> {
    private Expression<Player> players;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    public @Nullable Player[] get(Event e) {
        ArrayList list = new ArrayList();
        for (Player player : this.players.getArray(e)) {
            list.addAll(player.spigot().getHiddenPlayers());
        }
        return list.toArray(new Player[list.size()]);
    }

    public @Nullable Expression<Player> getPlayers() {
        return this.players;
    }

    @Override
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "hidden players for " + this.players.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHiddenPlayers.class, Player.class, ExpressionType.PROPERTY, "[(all [[of] the]|the)] hidden players (of|for) %players%", "[(all [[of] the]|the)] players hidden (from|for|by) %players%");
    }
}

