/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprItemsIn;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Inventory")
@Description(value={"The inventory of a block or player. You can usually omit this expression and can directly add or remove items to/from blocks or players."})
@Examples(value={"add a plank to the player's inventory", "clear the player's inventory", "remove 5 wool from the inventory of the clicked block"})
@Since(value="1.0")
public class ExprInventory
extends SimpleExpression<Object> {
    private boolean inLoop;
    private Expression<InventoryHolder> holders;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Node n = SkriptLogger.getNode();
        this.inLoop = n != null && ("loop " + parseResult.expr).equals(n.getKey());
        this.holders = exprs[0];
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        for (InventoryHolder holder : this.holders.getArray(e)) {
            inventories.add(holder.getInventory());
        }
        Object[] invArray = inventories.toArray(new Inventory[0]);
        if (this.inLoop) {
            ExprItemsIn expr = new ExprItemsIn();
            expr.init(new Expression[]{new SimpleExpression((Inventory[])invArray){
                final /* synthetic */ Inventory[] val$invArray;
                {
                    this.val$invArray = inventoryArray;
                }

                protected Object[] get(Event e) {
                    return this.val$invArray;
                }

                @Override
                public boolean isSingle() {
                    return this.val$invArray.length == 1;
                }

                @Override
                public Class<?> getReturnType() {
                    return Inventory.class;
                }

                @Override
                public String toString(@Nullable Event e, boolean debug) {
                    return "loop of inventory expression";
                }

                @Override
                public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
                    return true;
                }
            }}, 0, Kleenean.FALSE, null);
            return expr.get(e);
        }
        return invArray;
    }

    @Override
    public boolean isSingle() {
        return !this.inLoop && this.holders.isSingle();
    }

    @Override
    public Class<?> getReturnType() {
        return this.inLoop ? Slot.class : Inventory.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "inventor" + (this.holders.isSingle() ? "y" : "ies") + " of " + this.holders.toString(e, debug);
    }

    static {
        PropertyExpression.register(ExprInventory.class, Object.class, "inventor(y|ies)", "inventoryholders");
    }
}

