/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item")
@Description(value={"The item involved in an event, e.g. in a drop, dispense, pickup or craft event."})
@Examples(value={"on dispense:", "\titem is a clock", "\tset the time to 6:00"})
@Since(value="<i>unknown</i> (before 2.1)")
public class ExprItem
extends EventValueExpression<ItemStack> {
    private @Nullable EventValueExpression<Item> item;
    private @Nullable EventValueExpression<Slot> slot;

    public ExprItem() {
        super(ItemStack.class);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        this.item = new EventValueExpression<Item>(Item.class);
        if (this.item.init()) {
            return new Class[]{ItemType.class};
        }
        this.item = null;
        this.slot = new EventValueExpression<Slot>(Slot.class);
        if (this.slot.init()) {
            return new Class[]{ItemType.class};
        }
        this.slot = null;
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Slot s;
        assert (mode != Changer.ChangeMode.RESET);
        ItemType t = delta == null ? null : (ItemType)delta[0];
        Item i = this.item != null ? (Item)this.item.getSingle(e) : null;
        Slot slot = s = this.slot != null ? (Slot)this.slot.getSingle(e) : null;
        if (i == null && s == null) {
            return;
        }
        ItemStack is = i != null ? i.getItemStack() : (s != null ? s.getItem() : null);
        switch (mode) {
            case SET: {
                assert (t != null);
                is = t.getRandom();
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                assert (t != null);
                if (!t.isOfType(is)) break;
                if (mode == Changer.ChangeMode.ADD) {
                    is = t.addTo(is);
                    break;
                }
                if (mode == Changer.ChangeMode.REMOVE) {
                    is = t.removeFrom(is);
                    break;
                }
                is = t.removeAll(is);
                break;
            }
            case DELETE: {
                is = null;
                if (i == null) break;
                i.remove();
                break;
            }
            case RESET: {
                assert (false);
                break;
            }
        }
        if (i != null && is != null) {
            i.setItemStack(is);
        } else if (s != null) {
            s.setItem(is);
        } else assert (false);
    }

    static {
        Skript.registerExpression(ExprItem.class, ItemStack.class, ExpressionType.SIMPLE, "[the] item");
    }
}

