/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Amount")
@Description(value={"The amount of an <a href='classes.html#itemstack'>item stack</a>."})
@Examples(value={"send \"You have got %item amount of player's tool% %player's tool% in your hand!\" to player"})
@Since(value="2.2-dev24")
public class ExprItemAmount
extends SimplePropertyExpression<Object, Long> {
    @Override
    public Long convert(Object item) {
        return item instanceof ItemType ? ((ItemType)item).getAmount() : ((Slot)item).getAmount();
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Number.class) : null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int amount = delta != null ? ((Number)delta[0]).intValue() : 0;
        switch (mode) {
            case ADD: {
                for (Object obj : this.getExpr().getArray(event)) {
                    if (obj instanceof ItemType) {
                        ItemType item = (ItemType)obj;
                        item.setAmount(item.getAmount() + amount);
                        continue;
                    }
                    Slot slot = (Slot)obj;
                    slot.setAmount(slot.getAmount() + amount);
                }
                break;
            }
            case SET: {
                for (Object obj : this.getExpr().getArray(event)) {
                    if (obj instanceof ItemType) {
                        ((ItemType)obj).setAmount(amount);
                        continue;
                    }
                    ((Slot)obj).setAmount(amount);
                }
                break;
            }
            case REMOVE: {
                for (Object obj : this.getExpr().getArray(event)) {
                    if (obj instanceof ItemType) {
                        ItemType item = (ItemType)obj;
                        item.setAmount(item.getAmount() - amount);
                        continue;
                    }
                    Slot slot = (Slot)obj;
                    slot.setAmount(slot.getAmount() - amount);
                }
                break;
            }
            case REMOVE_ALL: 
            case RESET: 
            case DELETE: {
                for (Object obj : this.getExpr().getArray(event)) {
                    if (obj instanceof ItemType) {
                        ((ItemType)obj).setAmount(1);
                        continue;
                    }
                    ((Slot)obj).setAmount(1);
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    protected String getPropertyName() {
        return "item[[ ]stack] (amount|size|number)";
    }

    static {
        ExprItemAmount.register(ExprItemAmount.class, Long.class, "item[[ ]stack] (amount|size|number)", "slots/itemtypes");
    }
}

