/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Items In")
@Description(value={"All items in an inventory. Useful for looping or storing in a list variable.", "Please note that the positions of the items in the inventory are not saved, only their order is preserved."})
@Examples(value={"loop all items in the player's inventory:", "\tloop-item is enchanted", "\tremove loop-item from the player", "set {inventory::%uuid of player%::*} to items in the player's inventory"})
@Since(value="2.0")
public class ExprItemsIn
extends SimpleExpression<Slot> {
    private Expression<Inventory> invis;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed,  @Nullable SkriptParser.ParseResult parseResult) {
        this.invis = exprs[0];
        if (this.invis instanceof Variable && !this.invis.isSingle() && parseResult.mark != 1) {
            Skript.warning("'items in {variable::*}' does not actually represent the items stored in the variable. Use either '{variable::*}' (e.g. 'loop {variable::*}') if the variable contains items, or 'items in inventories {variable::*}' if the variable contains inventories.");
        }
        return true;
    }

    protected Slot[] get(Event e) {
        ArrayList<InventorySlot> r = new ArrayList<InventorySlot>();
        for (Inventory invi : this.invis.getArray(e)) {
            for (int i = 0; i < invi.getSize(); ++i) {
                if (invi.getItem(i) == null) continue;
                r.add(new InventorySlot(invi, i));
            }
        }
        return r.toArray(new Slot[r.size()]);
    }

    @Override
    public @Nullable Iterator<Slot> iterator(Event e) {
        final Iterator<Inventory> is = this.invis.iterator(e);
        if (is == null || !is.hasNext()) {
            return null;
        }
        return new Iterator<Slot>(){
            Inventory current;
            int next;
            {
                this.current = (Inventory)is.next();
                this.next = 0;
            }

            @Override
            public boolean hasNext() {
                while (this.next < this.current.getSize() && this.current.getItem(this.next) == null) {
                    ++this.next;
                }
                while (this.next >= this.current.getSize() && is.hasNext()) {
                    this.current = (Inventory)is.next();
                    this.next = 0;
                    while (this.next < this.current.getSize() && this.current.getItem(this.next) == null) {
                        ++this.next;
                    }
                }
                return this.next < this.current.getSize();
            }

            @Override
            public Slot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new InventorySlot(this.current, this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("item");
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "items in " + this.invis.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    static {
        Skript.registerExpression(ExprItemsIn.class, Slot.class, ExpressionType.PROPERTY, "[(all [[of] the]|the)] items ([with]in|of|contained in|out of) (|1\u00a6inventor(y|ies)) %inventories%");
    }
}

