/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.skript.util.slot.SlotWithIndex;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Slot Index")
@Description(value={"Index of an an inventory slot. Other types of slots may or may not have indices. Note that comparing slots with numbers is also possible; if index of slot is same as the number, comparisonsucceeds. This expression is mainly for the cases where you must for some reason save the slot numbers."})
@Examples(value={"if index of event-slot is 10:", "\tsend \"You bought a pie!\""})
@Since(value="2.2-dev35")
public class ExprSlotIndex
extends SimplePropertyExpression<Slot, Long> {
    @Override
    public @Nullable Long convert(Slot f) {
        if (f instanceof SlotWithIndex) {
            return ((SlotWithIndex)f).getIndex();
        }
        return 0L;
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    protected String getPropertyName() {
        return "slot";
    }

    static {
        ExprSlotIndex.register(ExprSlotIndex.class, Long.class, "index", "slots");
    }
}

