/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Sorted List")
@Description(value={"Sorts given list in natural order. All objects in list must be comparable;", "if they're not, this expression will return nothing."})
@Examples(value={"set {_sorted::*} to sorted {_players::*}"})
@Since(value="2.2-dev19")
public class ExprSortedList
extends SimpleExpression<Object> {
    private Expression<?> list;

    public ExprSortedList() {
    }

    public ExprSortedList(Expression<?> list) {
        this.list = list;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.list);
    }

    @Override
    protected @Nullable Object[] get(Event e) {
        ?[] unsorted = this.list.getArray(e);
        Object[] sorted = (Object[])Array.newInstance(this.getReturnType(), unsorted.length);
        for (int i = 0; i < sorted.length; ++i) {
            Object value = unsorted[i];
            sorted[i] = value instanceof Long ? Double.valueOf(((Long)value).longValue()) : value;
        }
        try {
            Arrays.sort(sorted);
        }
        catch (ClassCastException | IllegalArgumentException ex) {
            return new Object[0];
        }
        return sorted;
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        Expression<R> convertedList = this.list.getConvertedExpression(to);
        if (convertedList != null) {
            return new ExprSortedList(convertedList);
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<?> getReturnType() {
        return this.list.getReturnType();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "sorted " + this.list.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSortedList.class, Object.class, ExpressionType.COMBINED, "sorted %objects%");
    }
}

