/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.SpawnChangeEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Spawn")
@Description(value={"The spawn point of a world."})
@Examples(value={"teleport all players to spawn", "set the spawn point of \"world\" to the player's location"})
@Since(value="1.4.2")
public class ExprSpawn
extends PropertyExpression<World, Location> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Location[] get(Event e, World[] source) {
        if (this.getTime() == -1 && e instanceof SpawnChangeEvent && !Delay.isDelayed(e)) {
            return new Location[]{((SpawnChangeEvent)e).getPreviousLocation()};
        }
        return this.get(source, new Converter<World, Location>(){

            @Override
            public @Nullable Location convert(World w) {
                return w.getSpawnLocation();
            }
        });
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "spawn of " + this.getExpr().toString(e, debug);
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Location.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.SET);
        assert (delta != null);
        Location l = (Location)delta[0];
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        for (World w : (World[])this.getExpr().getArray(e)) {
            w.setSpawnLocation(x, y, z);
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), SpawnChangeEvent.class);
    }

    static {
        Skript.registerExpression(ExprSpawn.class, Location.class, ExpressionType.PROPERTY, "[the] spawn[s] [(point|location)[s]] [of %worlds%]", "%worlds%'[s] spawn[s] [(point|location)[s]]");
    }
}

