/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Time")
@Description(value={"The <a href='classes.html#time'>time</a> of a world."})
@Examples(value={"time in world is between 18:00 and 6:00:", "\tbroadcast \"It's night-time, watch out for monsters!\""})
@Since(value="1.0")
public class ExprTime
extends PropertyExpression<World, Time> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Time[] get(Event e, World[] source) {
        return this.get(source, new Getter<Time, World>(){

            @Override
            public Time get(World w) {
                return new Time((int)w.getTime());
            }
        });
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case REMOVE: {
                return CollectionUtils.array(Timespan.class);
            }
            case SET: {
                return CollectionUtils.array(Time.class, Timeperiod.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        World[] worlds = (World[])this.getExpr().getArray(e);
        int mod = 1;
        switch (mode) {
            case SET: {
                assert (delta != null);
                int time = delta[0] instanceof Time ? ((Time)delta[0]).getTicks() : ((Timeperiod)delta[0]).start;
                for (World w : worlds) {
                    w.setTime((long)time);
                }
                break;
            }
            case REMOVE: {
                mod = -1;
            }
            case ADD: {
                assert (delta != null);
                Timespan ts = (Timespan)delta[0];
                for (World w : worlds) {
                    w.setTime(w.getTime() + (long)mod * ts.getTicks_i());
                }
                break;
            }
            case DELETE: 
            case REMOVE_ALL: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Class<Time> getReturnType() {
        return Time.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (event == null) {
            return "the time in " + this.getExpr().toString(event, debug);
        }
        return Classes.getDebugMessage(this.getAll(event));
    }

    static {
        Skript.registerExpression(ExprTime.class, Time.class, ExpressionType.PROPERTY, "[the] time[s] [([with]in|of) %worlds%]", "%worlds%'[s] time[s]");
    }
}

