/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.slot.EquipmentSlot;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Tool")
@Description(value={"The item an entity is holding in their main or off hand."})
@Examples(value={"player's tool is a pickaxe", "player's off hand tool is a shield", "set tool of all players to a diamond sword", "set offhand tool of target entity to a bow"})
@Since(value="1.0")
public class ExprTool
extends PropertyExpression<LivingEntity, Slot> {
    private boolean offHand;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        this.offHand = parser.mark == 1;
        return true;
    }

    protected Slot[] get(final Event e, LivingEntity[] source) {
        final boolean delayed = Delay.isDelayed(e);
        return this.get(source, new Getter<Slot, LivingEntity>(){

            @Override
            public @Nullable Slot get(LivingEntity ent) {
                EntityEquipment eq;
                if (!delayed) {
                    if (!ExprTool.this.offHand && e instanceof PlayerItemHeldEvent && ((PlayerItemHeldEvent)e).getPlayer() == ent) {
                        PlayerInventory i = ((PlayerItemHeldEvent)e).getPlayer().getInventory();
                        return new InventorySlot((Inventory)i, ExprTool.this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot());
                    }
                    if (e instanceof PlayerBucketEvent && ((PlayerBucketEvent)e).getPlayer() == ent) {
                        PlayerInventory i = ((PlayerBucketEvent)e).getPlayer().getInventory();
                        boolean isOffHand = ((PlayerBucketEvent)e).getHand() == org.bukkit.inventory.EquipmentSlot.OFF_HAND || ExprTool.this.offHand;
                        return new InventorySlot((Inventory)i, isOffHand ? EquipmentSlot.EquipSlot.OFF_HAND.slotNumber : ((PlayerBucketEvent)e).getPlayer().getInventory().getHeldItemSlot()){

                            @Override
                            public @Nullable ItemStack getItem() {
                                return ExprTool.this.getTime() <= 0 ? super.getItem() : ((PlayerBucketEvent)e).getItemStack();
                            }

                            @Override
                            public void setItem(@Nullable ItemStack item) {
                                if (ExprTool.this.getTime() >= 0) {
                                    ((PlayerBucketEvent)e).setItemStack(item);
                                } else {
                                    super.setItem(item);
                                }
                            }
                        };
                    }
                }
                if ((eq = ent.getEquipment()) == null) {
                    return null;
                }
                return new EquipmentSlot(eq, ExprTool.this.offHand ? EquipmentSlot.EquipSlot.OFF_HAND : EquipmentSlot.EquipSlot.TOOL){

                    @Override
                    public String toString(@Nullable Event event, boolean debug) {
                        String time = ExprTool.this.getTime() == 1 ? "future " : (ExprTool.this.getTime() == -1 ? "former " : "");
                        String hand = ExprTool.this.offHand ? "off hand" : "";
                        String item = Classes.toString(this.getItem());
                        return String.format("%s %s tool of %s", time, hand, item);
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String hand = this.offHand ? "off hand" : "";
        return String.format("%s tool of %s", hand, this.getExpr().toString(e, debug));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerItemHeldEvent.class, PlayerBucketFillEvent.class, PlayerBucketEmptyEvent.class);
    }

    static {
        Skript.registerExpression(ExprTool.class, Slot.class, ExpressionType.PROPERTY, "[the] ((tool|held item|weapon)|1\u00a6(off[ ]hand (tool|item))) [of %livingentities%]", "%livingentities%'[s] ((tool|held item|weapon)|1\u00a6(off[ ]hand (tool|item)))");
    }
}

