/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="World")
@Description(value={"The world the event occurred in."})
@Examples(value={"world is \"world_nether\"", "teleport the player to the world's spawn", "set the weather in the player's world to rain", "set {_world} to world of event-chunk"})
@Since(value="1.0")
public class ExprWorld
extends PropertyExpression<Object, World> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        Expression<?> expr = exprs[0];
        if (expr == null && !((EventValueExpression)(expr = new EventValueExpression<World>(World.class))).init()) {
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    protected World[] get(final Event e, Object[] source) {
        if (source instanceof World[]) {
            return (World[])source;
        }
        return this.get(source, new Converter<Object, World>(){

            @Override
            public @Nullable World convert(Object o) {
                if (o instanceof Entity) {
                    if (ExprWorld.this.getTime() > 0 && e instanceof PlayerTeleportEvent && o.equals(((PlayerTeleportEvent)e).getPlayer()) && !Delay.isDelayed(e)) {
                        return ((PlayerTeleportEvent)e).getTo().getWorld();
                    }
                    return ((Entity)o).getWorld();
                }
                if (o instanceof Location) {
                    return ((Location)o).getWorld();
                }
                if (o instanceof Chunk) {
                    return ((Chunk)o).getWorld();
                }
                assert (false) : o;
                return null;
            }
        });
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(World.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        for (Object o : this.getExpr().getArray(e)) {
            if (!(o instanceof Location)) continue;
            ((Location)o).setWorld((World)delta[0]);
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerTeleportEvent.class);
    }

    @Override
    public Class<World> getReturnType() {
        return World.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the world" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(e, debug));
    }

    static {
        Skript.registerExpression(ExprWorld.class, World.class, ExpressionType.PROPERTY, "[the] world [of %locations/entities/chunk%]", "%locations/entities/chunk%'[s] world");
    }
}

