/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EventValueExpression<T>
extends SimpleExpression<T>
implements DefaultExpression<T> {
    private final Class<? extends T> c;
    private @Nullable Changer<? super T> changer;
    private final Map<Class<? extends Event>, Getter<? extends T, ?>> getters = new HashMap();

    public EventValueExpression(Class<? extends T> c) {
        this(c, null);
    }

    public EventValueExpression(Class<? extends T> c, @Nullable Changer<? super T> changer) {
        assert (c != null);
        this.c = c;
        this.changer = changer;
    }

    @Override
    protected @Nullable T[] get(Event e) {
        T o = this.getValue(e);
        if (o == null) {
            return null;
        }
        Object[] one = (Object[])Array.newInstance(this.c, 1);
        one[0] = o;
        return one;
    }

    private <E extends Event> @Nullable T getValue(E e) {
        if (this.getters.containsKey(e.getClass())) {
            Getter<? extends T, ?> g = this.getters.get(e.getClass());
            return g == null ? null : (T)g.get(e);
        }
        for (Map.Entry<Class<Event>, Getter<T, ?>> p : this.getters.entrySet()) {
            if (!p.getKey().isAssignableFrom(e.getClass())) continue;
            this.getters.put(e.getClass(), p.getValue());
            return p.getValue() == null ? null : (T)p.getValue().get(e);
        }
        this.getters.put(e.getClass(), null);
        return null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length != 0) {
            throw new SkriptAPIException(this.getClass().getName() + " has expressions in its pattern but does not override init(...)");
        }
        return this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean hasValue = false;
            Class<? extends Event>[] es = this.getParser().getCurrentEvents();
            if (es == null) {
                assert (false);
                boolean bl = false;
                return bl;
            }
            for (Class<? extends Event> e : es) {
                if (this.getters.containsKey(e)) {
                    hasValue = this.getters.get(e) != null;
                    continue;
                }
                Getter<? extends T, ? extends Event> getter = EventValues.getEventValueGetter(e, this.c, this.getTime());
                if (getter == null) continue;
                this.getters.put(e, getter);
                hasValue = true;
            }
            if (!hasValue) {
                log.printError("There's no " + Classes.getSuperClassInfo(this.c).getName() + " in " + Utils.a(this.getParser().getCurrentEventName()) + " event");
                boolean bl = false;
                return bl;
            }
            log.printLog();
            boolean bl = true;
            return bl;
        }
        finally {
            log.stop();
        }
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.c;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (!debug || e == null) {
            return "event-" + Classes.getSuperClassInfo(this.c).getName();
        }
        return Classes.getDebugMessage(this.getValue(e));
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Changer<T> ch = this.changer;
        if (ch == null) {
            ch = Classes.getSuperClassInfo(this.c).getChanger();
            this.changer = ch;
        }
        return ch == null ? null : ch.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Changer<? super T> ch = this.changer;
        if (ch == null) {
            throw new UnsupportedOperationException();
        }
        Changer.ChangerUtils.change(ch, this.getArray(e), delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        Class<? extends Event>[] es = this.getParser().getCurrentEvents();
        if (es == null) {
            assert (false);
            return false;
        }
        for (Class<? extends Event> e : es) {
            assert (e != null);
            if (!EventValues.doesEventValueHaveTimeStates(e, this.c)) continue;
            super.setTime(time);
            this.getters.clear();
            this.init();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

