/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Can Build")
@Description(value={"Tests whether a player is allowed to build at a certain location.", "This condition requires a supported <a href='../classes.html#region'>regions</a> plugin to be installed."})
@Examples(value={"command /setblock &lt;material&gt;:", "\tdescription: set the block at your crosshair to a different type", "\ttrigger:", "\t\tplayer cannot build at the targeted block:", "\t\t\tmessage \"You do not have permission to change blocks there!\"", "\t\t\tstop", "\t\tset the targeted block to argument"})
@Since(value="2.0")
public class CondCanBuild
extends Condition {
    private Expression<Player> players;
    Expression<Location> locations;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondCanBuild.this.locations.check(e, new Checker<Location>(){

                    @Override
                    public boolean check(Location l) {
                        return RegionsPlugin.canBuild(p, l);
                    }
                }, CondCanBuild.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.players.toString(e, debug) + " can build " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerCondition(CondCanBuild.class, "%players% (can|(is|are) allowed to) build %directions% %locations%", "%players% (can('t|not)|(is|are)(n't| not) allowed to) build %directions% %locations%");
    }
}

