/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Checker;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public interface Expression<T>
extends SyntaxElement,
Debuggable {
    public @Nullable T getSingle(Event var1);

    public T[] getArray(Event var1);

    public T[] getAll(Event var1);

    default public Stream<? extends T> stream(Event e) {
        Iterator<T> iter = this.iterator(e);
        if (iter == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 0), false);
    }

    public boolean isSingle();

    public boolean check(Event var1, Checker<? super T> var2, boolean var3);

    public boolean check(Event var1, Checker<? super T> var2);

    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... var1);

    public Class<? extends T> getReturnType();

    public boolean getAnd();

    public boolean setTime(int var1);

    public int getTime();

    public boolean isDefault();

    public @Nullable Iterator<? extends T> iterator(Event var1);

    public boolean isLoopOf(String var1);

    public Expression<?> getSource();

    public Expression<? extends T> simplify();

    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode var1);

    public void change(Event var1, @Nullable Object[] var2, Changer.ChangeMode var3);

    default public @Nullable Object[] beforeChange(Expression<?> changed, @Nullable Object[] delta) {
        if (delta == null || delta.length == 0) {
            return null;
        }
        Object[] newDelta = null;
        if (changed instanceof Variable) {
            newDelta = new Object[delta.length];
            for (int i = 0; i < delta.length; ++i) {
                Object value = delta[i];
                if (value instanceof Slot) {
                    ItemStack item = ((Slot)value).getItem();
                    if (item != null) {
                        item = item.clone();
                    }
                    newDelta[i] = item;
                    continue;
                }
                newDelta[i] = Classes.clone(delta[i]);
            }
        }
        return newDelta == null ? delta : newDelta;
    }
}

