/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Signature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class Namespace {
    private final Map<String, Signature<?>> signatures = new HashMap();
    private final Map<String, Function<?>> functions = new HashMap();

    public @Nullable Signature<?> getSignature(String name) {
        return this.signatures.get(name);
    }

    public void addSignature(Signature<?> sign) {
        if (this.signatures.containsKey(sign.getName())) {
            throw new IllegalArgumentException("function name already used");
        }
        this.signatures.put(sign.getName(), sign);
    }

    public Collection<Signature<?>> getSignatures() {
        return this.signatures.values();
    }

    public @Nullable Function<?> getFunction(String name) {
        return this.functions.get(name);
    }

    public void addFunction(Function<?> func) {
        assert (this.signatures.containsKey(func.getName())) : "missing signature for function";
        this.functions.put(func.getName(), func);
    }

    public Collection<Function<?>> getFunctions() {
        return this.functions.values();
    }

    public static class Key {
        private final Origin origin;
        private final String name;

        public Key(Origin origin, String name) {
            this.origin = origin;
            this.name = name;
        }

        public Origin getOrigin() {
            return this.origin;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + this.name.hashCode();
            result = prime * result + this.origin.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.origin == other.origin;
        }
    }

    public static enum Origin {
        JAVA,
        SCRIPT;

    }
}

