/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.variables.Variables;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptFunction<T>
extends Function<T> {
    private final Trigger trigger;
    private boolean returnValueSet = false;
    private @Nullable T[] returnValue = null;

    public ScriptFunction(Signature<T> sign, SectionNode node) {
        super(sign);
        Functions.currentFunction = this;
        try {
            this.trigger = new Trigger(node.getConfig().getFile(), "function " + sign.getName(), new SimpleEvent(), ScriptLoader.loadItems(node));
            this.trigger.setLineNumber(node.getLine());
        }
        finally {
            Functions.currentFunction = null;
        }
    }

    public final void setReturnValue(@Nullable T[] value) {
        assert (!this.returnValueSet);
        this.returnValueSet = true;
        this.returnValue = value;
    }

    @Override
    public @Nullable T[] execute(FunctionEvent<?> e, Object[][] params) {
        Parameter<?>[] parameters = this.getSignature().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter<?> p = parameters[i];
            Object[] val = params[i];
            if (p.single && val.length > 0) {
                Variables.setVariable(p.name, val[0], e, true);
                continue;
            }
            for (int j = 0; j < val.length; ++j) {
                Variables.setVariable(p.name + "::" + (j + 1), val[j], e, true);
            }
        }
        this.trigger.execute(e);
        return this.returnValue;
    }

    @Override
    public boolean resetReturnValue() {
        this.returnValue = null;
        this.returnValueSet = false;
        return true;
    }
}

