/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.function.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.Nullable;

public class Signature<T> {
    final String script;
    final String name;
    final Parameter<?>[] parameters;
    final @Nullable ClassInfo<T> returnType;
    final boolean single;
    final Collection<FunctionReference<?>> calls;

    public Signature(String script, String name, Parameter<?>[] parameters, @Nullable ClassInfo<T> returnType, boolean single) {
        this.script = script;
        this.name = name;
        this.parameters = parameters;
        this.returnType = returnType;
        this.single = single;
        this.calls = Collections.newSetFromMap(new WeakHashMap());
    }

    public String getName() {
        return this.name;
    }

    public Parameter<?> getParameter(int index) {
        return this.parameters[index];
    }

    public Parameter<?>[] getParameters() {
        return this.parameters;
    }

    public @Nullable ClassInfo<T> getReturnType() {
        return this.returnType;
    }

    public boolean isSingle() {
        return this.single;
    }

    public int getMaxParameters() {
        return this.parameters.length;
    }

    public int getMinParameters() {
        for (int i = this.parameters.length - 1; i >= 0; --i) {
            if (this.parameters[i].def != null) continue;
            return i + 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

