/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.config.Config;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class Language {
    public static final int F_PLURAL = 1;
    public static final int F_DEFINITE_ARTICLE = 2;
    public static final int F_INDEFINITE_ARTICLE = 4;
    public static final int NO_ARTICLE_MASK = -7;
    private static String name = "english";
    private static final HashMap<String, String> defaultLanguage = new HashMap();
    private static @Nullable HashMap<String, String> localizedLanguage = null;
    private static final HashMap<Plugin, Version> langVersion = new HashMap();
    private static final Pattern listSplitPattern = Pattern.compile("\\s*,\\s*");
    private static final List<LanguageChangeListener> listeners = new ArrayList<LanguageChangeListener>();
    private static final int[] priorityStartIndices = new int[LanguageListenerPriority.values().length];

    public static String getName() {
        return name;
    }

    private static @Nullable String get_i(String key) {
        String value = defaultLanguage.get(key);
        if (value != null) {
            return value;
        }
        if (localizedLanguage != null && (value = localizedLanguage.get(key)) != null) {
            return value;
        }
        if (Skript.testing()) {
            Language.missingEntryError(key);
        }
        return null;
    }

    public static String get(String key) {
        String s = Language.get_i("" + key.toLowerCase(Locale.ENGLISH));
        return s == null ? "" + key.toLowerCase(Locale.ENGLISH) : s;
    }

    public static @Nullable String get_(String key) {
        return Language.get_i("" + key.toLowerCase(Locale.ENGLISH));
    }

    public static void missingEntryError(String key) {
        Skript.error("Missing entry '" + key.toLowerCase(Locale.ENGLISH) + "' in the default/english language file");
    }

    public static String format(String key, Object ... args) {
        key = "" + key.toLowerCase(Locale.ENGLISH);
        String value = Language.get_i(key);
        if (value == null) {
            return key;
        }
        try {
            return "" + String.format(value, args);
        }
        catch (Exception e) {
            Skript.error("Invalid format string at '" + key + "' in the " + Language.getName() + " language file: " + value);
            return key;
        }
    }

    public static String getSpaced(String key) {
        String s = Language.get(key);
        if (s.isEmpty()) {
            return " ";
        }
        return " " + s + " ";
    }

    public static String[] getList(String key) {
        String s = Language.get_i("" + key.toLowerCase(Locale.ENGLISH));
        if (s == null) {
            return new String[]{key.toLowerCase(Locale.ENGLISH)};
        }
        String[] r = listSplitPattern.split(s);
        assert (r != null);
        return r;
    }

    public static boolean keyExists(String key) {
        return defaultLanguage.containsKey(key = key.toLowerCase(Locale.ENGLISH)) || localizedLanguage != null && localizedLanguage.containsKey(key);
    }

    public static boolean keyExistsDefault(String key) {
        return defaultLanguage.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isInitialized() {
        return !defaultLanguage.isEmpty();
    }

    public static void loadDefault(SkriptAddon addon) {
        if (addon.getLanguageFileDirectory() == null) {
            return;
        }
        InputStream defaultIs = addon.plugin.getResource(addon.getLanguageFileDirectory() + "/default.lang");
        InputStream englishIs = addon.plugin.getResource(addon.getLanguageFileDirectory() + "/english.lang");
        if (defaultIs == null) {
            if (englishIs == null) {
                throw new IllegalStateException(addon + " is missing the required default.lang file!");
            }
            defaultIs = englishIs;
            englishIs = null;
        }
        HashMap<String, String> def = Language.load(defaultIs, "default");
        HashMap<String, String> en = Language.load(englishIs, "english");
        String v = def.get("version");
        if (v == null) {
            Skript.warning("Missing version in default.lang");
        }
        langVersion.put((Plugin)addon.plugin, v == null ? Skript.getVersion() : new Version(v));
        def.remove("version");
        defaultLanguage.putAll(def);
        if (localizedLanguage == null) {
            localizedLanguage = new HashMap();
        }
        localizedLanguage.putAll(en);
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
    }

    public static boolean load(String name) {
        name = "" + name.toLowerCase(Locale.ENGLISH);
        localizedLanguage = new HashMap();
        boolean exists = Language.load(Skript.getAddonInstance(), name);
        for (SkriptAddon addon : Skript.getAddons()) {
            exists |= Language.load(addon, name);
        }
        if (!exists) {
            if (name.equals("english")) {
                throw new RuntimeException("English language is missing (english.lang)");
            }
            Language.load("english");
            return false;
        }
        Language.name = name;
        for (LanguageChangeListener l : listeners) {
            l.onLanguageChange();
        }
        return true;
    }

    private static boolean load(SkriptAddon addon, String name) {
        HashMap<String, String> l;
        block17: {
            if (addon.getLanguageFileDirectory() == null) {
                return false;
            }
            if (name.equals("english") && addon.plugin.getResource(addon.getLanguageFileDirectory() + "/default.lang") == null) {
                return true;
            }
            l = Language.load(addon.plugin.getResource(addon.getLanguageFileDirectory() + "/" + name + ".lang"), name);
            File file = new File(addon.plugin.getDataFolder(), addon.getLanguageFileDirectory() + File.separator + name + ".lang");
            try {
                if (file.exists()) {
                    l.putAll(Language.load(new FileInputStream(file), name));
                }
            }
            catch (FileNotFoundException e) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        if (l.isEmpty()) {
            return false;
        }
        if (!l.containsKey("version")) {
            Skript.error(addon + "'s language file " + name + ".lang does not provide a version number!");
        } else {
            try {
                Version v = new Version("" + l.get("version"));
                Version lv = langVersion.get(addon.plugin);
                assert (lv != null);
                if (v.isSmallerThan(lv)) {
                    Skript.warning(addon + "'s language file " + name + ".lang is outdated, some messages will be english.");
                }
            }
            catch (IllegalArgumentException e) {
                Skript.error("Illegal version syntax in " + addon + "'s language file " + name + ".lang: " + e.getLocalizedMessage());
            }
        }
        l.remove("version");
        if (localizedLanguage != null) {
            for (Map.Entry<String, String> entry : l.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (defaultLanguage.containsKey(key)) {
                    Skript.warning("'" + key + "' is part of the default language file, and can therefore not be modified in a localized language file.");
                    continue;
                }
                localizedLanguage.put(key, value);
            }
        } else assert (false) : addon + "; " + name;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, String> load(@Nullable InputStream in, String name) {
        if (in == null) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> hashMap = new Config(in, name + ".lang", false, false, ":").toMap(".");
            return hashMap;
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, "Could not load the language file '" + name + ".lang': " + ExceptionUtils.toString(e));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void addListener(LanguageChangeListener listener) {
        Language.addListener(listener, LanguageListenerPriority.NORMAL);
    }

    public static void addListener(LanguageChangeListener listener, LanguageListenerPriority priority) {
        listeners.add(priorityStartIndices[priority.ordinal()], listener);
        int i = priority.ordinal() + 1;
        while (i < LanguageListenerPriority.values().length) {
            int n = i++;
            priorityStartIndices[n] = priorityStartIndices[n] + 1;
        }
        if (Language.isInitialized()) {
            listener.onLanguageChange();
        }
    }

    public static enum LanguageListenerPriority {
        EARLIEST,
        NORMAL,
        LATEST;

    }
}

