/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.patterns.GroupPatternElement;
import ch.njol.skript.patterns.LiteralPatternElement;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternElement;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class SkriptPattern {
    private final PatternElement first;
    private final int expressionAmount;
    private final String[] keywords;

    public SkriptPattern(PatternElement first, int expressionAmount) {
        this.first = first;
        this.expressionAmount = expressionAmount;
        this.keywords = SkriptPattern.getKeywords(first);
    }

    @Nullable
    public MatchResult match(String expr, int flags, ParseContext parseContext) {
        String lowerExpr = expr.toLowerCase(Locale.ENGLISH);
        for (String keyword : this.keywords) {
            if (lowerExpr.contains(keyword)) continue;
            return null;
        }
        expr = expr.trim();
        MatchResult matchResult = new MatchResult();
        matchResult.expr = expr;
        matchResult.expressions = new Expression[this.expressionAmount];
        matchResult.parseContext = parseContext;
        matchResult.flags = flags;
        return this.first.match(expr, matchResult);
    }

    @Nullable
    public MatchResult match(String expr) {
        return this.match(expr, 3, ParseContext.DEFAULT);
    }

    public String toString() {
        return this.first.toFullString();
    }

    public static String[] getKeywords(PatternElement first) {
        ArrayList<String> keywords = new ArrayList<String>();
        PatternElement next = first;
        while (next != null) {
            if (next instanceof LiteralPatternElement) {
                String literal = next.toString().trim();
                while (literal.contains("  ")) {
                    literal = literal.replace("  ", " ");
                }
                keywords.add(literal);
            } else if (next instanceof GroupPatternElement) {
                next = ((GroupPatternElement)next).getPatternElement();
                continue;
            }
            next = next.next;
        }
        return keywords.toArray(new String[0]);
    }
}

