/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.patterns.MatchResult;
import ch.njol.skript.patterns.PatternElement;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import org.jetbrains.annotations.Nullable;

public class TypePatternElement
extends PatternElement {
    private final ClassInfo<?>[] classes;
    private final boolean[] isPlural;
    private final boolean isNullable;
    private final int flagMask;
    private final int time;
    private final int expressionIndex;

    public TypePatternElement(ClassInfo<?>[] classes, boolean[] isPlural, boolean isNullable, int flagMask, int time, int expressionIndex) {
        this.classes = classes;
        this.isPlural = isPlural;
        this.isNullable = isNullable;
        this.flagMask = flagMask;
        this.time = time;
        this.expressionIndex = expressionIndex;
    }

    public static TypePatternElement fromString(String s, int expressionIndex) {
        boolean isNullable = s.startsWith("-");
        if (isNullable) {
            s = s.substring(1);
        }
        int flagMask = -1;
        if (s.startsWith("*")) {
            s = s.substring(1);
            flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            flagMask &= 0xFFFFFFFD;
        }
        if (!isNullable && (isNullable = s.startsWith("-"))) {
            s = s.substring(1);
        }
        int time = 0;
        int timeStart = s.indexOf("@");
        if (timeStart != -1) {
            time = Integer.parseInt(s.substring(timeStart + 1));
            s = s.substring(0, timeStart);
        }
        String[] classes = s.split("/");
        ClassInfo[] classInfos = new ClassInfo[classes.length];
        boolean[] isPlural = new boolean[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            classInfos[i] = Classes.getClassInfo(p.getFirst());
            isPlural[i] = p.getSecond();
        }
        return new TypePatternElement(classInfos, isPlural, isNullable, flagMask, time, expressionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public MatchResult match(String expr, MatchResult matchResult) {
        int newExprOffset;
        if (this.next == null) {
            newExprOffset = expr.length();
        } else {
            newExprOffset = SkriptParser.next(expr, matchResult.exprOffset, matchResult.parseContext);
            if (newExprOffset == -1) {
                return null;
            }
        }
        SkriptParser.ExprInfo exprInfo = this.getExprInfo();
        ParseLogHandler loopLogHandler = SkriptLogger.startParseLogHandler();
        try {
            while (newExprOffset != -1) {
                loopLogHandler.clear();
                MatchResult matchResultCopy = matchResult.copy();
                matchResultCopy.exprOffset = newExprOffset;
                MatchResult newMatchResult = this.matchNext(expr, matchResultCopy);
                if (newMatchResult != null) {
                    ParseLogHandler expressionLogHandler = SkriptLogger.startParseLogHandler();
                    try {
                        Expression<?> expression = new SkriptParser(expr.substring(matchResult.exprOffset, newExprOffset), matchResult.flags & this.flagMask, matchResult.parseContext).parseExpression(exprInfo);
                        if (expression != null) {
                            if (this.time != 0) {
                                if (expression instanceof Literal) {
                                    MatchResult matchResult2 = null;
                                    return matchResult2;
                                }
                                if (ParserInstance.get().getHasDelayBefore() == Kleenean.TRUE) {
                                    Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
                                    MatchResult matchResult3 = null;
                                    return matchResult3;
                                }
                                if (!expression.setTime(this.time)) {
                                    Skript.error(expression + " does not have a " + (this.time == -1 ? "past" : "future") + " state", ErrorQuality.SEMANTIC_ERROR);
                                    MatchResult matchResult4 = null;
                                    return matchResult4;
                                }
                            }
                            expressionLogHandler.printLog();
                            loopLogHandler.printLog();
                            newMatchResult.expressions[this.expressionIndex] = expression;
                            MatchResult matchResult5 = newMatchResult;
                            return matchResult5;
                        }
                    }
                    finally {
                        expressionLogHandler.printError();
                    }
                }
                newExprOffset = SkriptParser.next(expr, newExprOffset, matchResult.parseContext);
            }
            return null;
        }
        finally {
            if (!loopLogHandler.isStopped()) {
                loopLogHandler.printError();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("%");
        if (this.isNullable) {
            stringBuilder.append("-");
        }
        if (this.flagMask != -1) {
            if ((this.flagMask & 2) == 0) {
                stringBuilder.append("~");
            } else if ((this.flagMask & 1) == 0) {
                stringBuilder.append("*");
            }
        }
        for (int i = 0; i < this.classes.length; ++i) {
            String codeName = this.classes[i].getCodeName();
            if (this.isPlural[i]) {
                stringBuilder.append(Utils.toEnglishPlural(codeName));
            } else {
                stringBuilder.append(codeName);
            }
            if (i == this.classes.length - 1) continue;
            stringBuilder.append("/");
        }
        if (this.time != 0) {
            stringBuilder.append("@").append(this.time);
        }
        return stringBuilder.append("%").toString();
    }

    private SkriptParser.ExprInfo getExprInfo() {
        SkriptParser.ExprInfo exprInfo = new SkriptParser.ExprInfo(this.classes.length);
        for (int i = 0; i < this.classes.length; ++i) {
            exprInfo.classes[i] = this.classes[i];
            exprInfo.isPlural[i] = this.isPlural[i];
        }
        exprInfo.isOptional = this.isNullable;
        exprInfo.flagMask = this.flagMask;
        exprInfo.time = this.time;
        return exprInfo;
    }
}

