/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Getter;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.util.Consumer;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@Name(value="Spawn")
@Description(value={"Spawn a creature. This can be used as an effect and as a section.", "If it is used as a section, the section is run before the entity is added to the world.", "You can modify the entity in this section, using for example 'event-entity' or 'cow'. ", "Do note that other event values, such as 'player', won't work in this section."})
@Examples(value={"spawn 3 creepers at the targeted block", "spawn a ghast 5 meters above the player", "spawn a zombie at the player:", "\tset name of the zombie to \"\""})
@Since(value="1.0, 2.6.1 (with section)")
public class EffSecSpawn
extends EffectSection {
    private static final boolean BUKKIT_CONSUMER_EXISTS;
    public static @Nullable Entity lastSpawned;
    private Expression<Location> locations;
    private Expression<EntityType> types;
    private @Nullable Expression<Number> amount;
    private @Nullable Trigger trigger;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.amount = matchedPattern == 0 ? null : exprs[0];
        this.types = exprs[matchedPattern];
        this.locations = Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        if (sectionNode != null) {
            if (!BUKKIT_CONSUMER_EXISTS) {
                Skript.error("The spawn section isn't available on your Minecraft version, use a spawn effect instead");
                return false;
            }
            this.trigger = this.loadCode(sectionNode, "spawn", SpawnEvent.class);
        }
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        Integer a;
        lastSpawned = null;
        Object localVars = Variables.copyLocalVariables(e);
        Consumer consumer = this.trigger != null ? o -> {
            lastSpawned = o;
            SpawnEvent spawnEvent = new SpawnEvent((Entity)o);
            Variables.setLocalVariables(spawnEvent, localVars);
            this.trigger.execute(spawnEvent);
        } : null;
        Number number = a = this.amount != null ? (Number)this.amount.getSingle(e) : (Number)1;
        if (a != null) {
            EntityType[] ts = this.types.getArray(e);
            for (Location l : this.locations.getArray(e)) {
                for (EntityType type : ts) {
                    int i = 0;
                    while ((double)i < ((Number)a).doubleValue() * (double)type.getAmount()) {
                        if (consumer != null) {
                            type.data.spawn(l, consumer);
                        } else {
                            lastSpawned = type.data.spawn(l);
                        }
                        ++i;
                    }
                }
            }
        }
        return super.walk(e, false);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "spawn " + (this.amount != null ? this.amount.toString(e, debug) + " of " : "") + this.types.toString(e, debug) + " " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerSection(EffSecSpawn.class, "(spawn|summon) %entitytypes% [%directions% %locations%]", "(spawn|summon) %number% of %entitytypes% [%directions% %locations%]");
        EventValues.registerEventValue(SpawnEvent.class, Entity.class, new Getter<Entity, SpawnEvent>(){

            @Override
            public Entity get(SpawnEvent spawnEvent) {
                return spawnEvent.getEntity();
            }
        }, 0);
        BUKKIT_CONSUMER_EXISTS = Skript.classExists("org.bukkit.util.Consumer");
        lastSpawned = null;
    }

    public static class SpawnEvent
    extends Event {
        private final Entity entity;

        public SpawnEvent(Entity entity) {
            this.entity = entity;
        }

        public Entity getEntity() {
            return this.entity;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException();
        }
    }
}

