/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.events.bukkit.SkriptParseEvent;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class SecConditional
extends Section {
    private ConditionalType type;
    private Condition condition;
    private boolean parseIf;
    private boolean parseIfPassed;
    private Kleenean hasDelayAfter;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        SecConditional lastIf;
        this.type = ConditionalType.values()[matchedPattern];
        boolean bl = this.parseIf = parseResult.mark == 1;
        if (this.type == ConditionalType.IF || this.type == ConditionalType.ELSE_IF) {
            String expr = parseResult.regexes.get(0).group();
            ParserInstance parser = this.getParser();
            Class<? extends Event>[] currentEvents = parser.getCurrentEvents();
            String currentEventName = parser.getCurrentEventName();
            SkriptEvent currentSkriptEvent = parser.getCurrentSkriptEvent();
            if (this.parseIf) {
                parser.setCurrentEvents(new Class[]{SkriptParseEvent.class});
                parser.setCurrentEventName("parse");
                parser.setCurrentSkriptEvent(null);
            }
            this.condition = Condition.parse(expr, parseResult.mark != 0 ? "Can't understand this condition: '" + expr + "'" : null);
            if (this.parseIf) {
                parser.setCurrentEvents(currentEvents);
                parser.setCurrentEventName(currentEventName);
                parser.setCurrentSkriptEvent(currentSkriptEvent);
            }
            if (this.condition == null) {
                return false;
            }
        }
        if (this.type != ConditionalType.IF) {
            lastIf = SecConditional.getIf(triggerItems);
            if (lastIf == null) {
                if (this.type == ConditionalType.ELSE_IF) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                } else {
                    Skript.error("'else' has to be placed just after another 'if' or 'else if' section");
                }
                return false;
            }
        } else {
            lastIf = null;
        }
        if (this.parseIf) {
            if (!this.condition.check(new SkriptParseEvent())) {
                return true;
            }
            this.parseIfPassed = true;
        }
        Kleenean hadDelayBefore = this.getParser().getHasDelayBefore();
        this.loadCode(sectionNode);
        this.hasDelayAfter = this.getParser().getHasDelayBefore();
        if (hadDelayBefore.isTrue() || hadDelayBefore.equals((Object)this.hasDelayAfter)) {
            return true;
        }
        if (this.type == ConditionalType.ELSE) {
            if (this.hasDelayAfter.isTrue() && lastIf.hasDelayAfter.isTrue() && SecConditional.getElseIfs(triggerItems).stream().map(SecConditional::getHasDelayAfter).allMatch(Kleenean::isTrue)) {
                this.getParser().setHasDelayBefore(Kleenean.TRUE);
            } else {
                this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
            }
        } else if (!this.hasDelayAfter.isFalse()) {
            this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
        }
        return true;
    }

    @Override
    public @Nullable TriggerItem getNext() {
        return this.getSkippedNext();
    }

    public @Nullable TriggerItem getNormalNext() {
        return super.getNext();
    }

    @Override
    protected @Nullable TriggerItem walk(Event e) {
        if (this.parseIf && !this.parseIfPassed) {
            return this.getNormalNext();
        }
        if (this.type == ConditionalType.ELSE || this.parseIf || this.condition.check(e)) {
            TriggerItem skippedNext = this.getSkippedNext();
            if (this.last != null) {
                this.last.setNext(skippedNext);
            }
            return this.first != null ? this.first : skippedNext;
        }
        return this.getNormalNext();
    }

    private @Nullable TriggerItem getSkippedNext() {
        TriggerItem next = this.getNormalNext();
        while (next instanceof SecConditional && ((SecConditional)next).type != ConditionalType.IF) {
            next = ((SecConditional)next).getNormalNext();
        }
        return next;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String parseIf = this.parseIf ? "parse " : "";
        switch (this.type) {
            case IF: {
                return parseIf + "if " + this.condition.toString(e, debug);
            }
            case ELSE_IF: {
                return "else " + parseIf + "if " + this.condition.toString(e, debug);
            }
            case ELSE: {
                return "else";
            }
        }
        throw new IllegalStateException();
    }

    private Kleenean getHasDelayAfter() {
        return this.hasDelayAfter;
    }

    private static @Nullable SecConditional getIf(List<TriggerItem> triggerItems) {
        for (int i = triggerItems.size() - 1; i >= 0; --i) {
            TriggerItem triggerItem = triggerItems.get(i);
            if (triggerItem instanceof SecConditional) {
                SecConditional secConditional = (SecConditional)triggerItem;
                if (secConditional.type == ConditionalType.IF) {
                    return secConditional;
                }
                if (secConditional.type != ConditionalType.ELSE) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    private static List<SecConditional> getElseIfs(List<TriggerItem> triggerItems) {
        TriggerItem triggerItem;
        ArrayList<SecConditional> list = new ArrayList<SecConditional>();
        for (int i = triggerItems.size() - 1; i >= 0 && (triggerItem = triggerItems.get(i)) instanceof SecConditional; --i) {
            SecConditional secConditional = (SecConditional)triggerItem;
            if (secConditional.type != ConditionalType.ELSE_IF) break;
            list.add(secConditional);
        }
        return list;
    }

    static {
        Skript.registerSection(SecConditional.class, "else", "else [(1\u00a6parse)] if <.+>", "[(1\u00a6parse if|2\u00a6if)] <.+>");
    }

    private static enum ConditionalType {
        ELSE,
        ELSE_IF,
        IF;

    }
}

