/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.tests.platform;

import ch.njol.skript.tests.TestResults;
import ch.njol.skript.tests.platform.Environment;
import ch.njol.util.NonNullPair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PlatformMain {
    public static void main(String ... args) throws IOException, InterruptedException {
        System.out.println("Initializing Skript test platform...");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path runnerRoot = Paths.get(args[0], new String[0]);
        assert (runnerRoot != null);
        Path testsRoot = Paths.get(args[1], new String[0]).toAbsolutePath();
        assert (testsRoot != null);
        Path dataRoot = Paths.get(args[2], new String[0]);
        assert (dataRoot != null);
        Path envsRoot = Paths.get(args[3], new String[0]);
        assert (envsRoot != null);
        boolean devMode = "true".equals(args[4]);
        boolean genDocs = "true".equals(args[5]);
        List<Environment> envs = Files.isDirectory(envsRoot, new LinkOption[0]) ? Files.walk(envsRoot, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> {
            try {
                return (Environment)gson.fromJson(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), Environment.class);
            }
            catch (JsonSyntaxException | IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()) : Collections.singletonList((Environment)gson.fromJson(new String(Files.readAllBytes(envsRoot), StandardCharsets.UTF_8), Environment.class));
        System.out.println("Test environments: " + String.join((CharSequence)", ", envs.stream().map(Environment::getName).collect(Collectors.toList())));
        HashSet<String> allTests = new HashSet<String>();
        HashMap<String, List> failures = new HashMap<String, List>();
        boolean docsFailed = false;
        envs.sort(Comparator.comparing(Environment::getName));
        for (Environment env : envs) {
            System.out.println("Starting testing on " + env.getName());
            env.initialize(dataRoot, runnerRoot, false);
            TestResults results = env.runTests(runnerRoot, testsRoot, devMode, genDocs, "-Xmx5G");
            if (results == null) {
                if (devMode) {
                    System.exit(0);
                    return;
                }
                System.err.println("The test environment '" + env.getName() + "' failed to produce test results.");
                System.exit(3);
                return;
            }
            docsFailed = results.docsFailed();
            allTests.addAll(results.getSucceeded());
            allTests.addAll(results.getFailed().keySet());
            for (Map.Entry<String, String> fail : results.getFailed().entrySet()) {
                String error = fail.getValue();
                assert (error != null);
                failures.computeIfAbsent(fail.getKey(), k -> new ArrayList()).add(new NonNullPair<Environment, String>(env, error));
            }
        }
        if (docsFailed) {
            System.err.println("Documentation templates not found. Cannot generate docs!");
            System.exit(2);
            return;
        }
        if (genDocs) {
            System.exit(0);
            return;
        }
        List succeeded = allTests.stream().filter(name -> !failures.containsKey(name)).collect(Collectors.toList());
        Collections.sort(succeeded);
        ArrayList failNames = new ArrayList(failures.keySet());
        Collections.sort(failNames);
        System.out.printf("%s Results %s%n", StringUtils.repeat((String)"-", (int)25), StringUtils.repeat((String)"-", (int)25));
        System.out.println("Tested environments: " + String.join((CharSequence)", ", envs.stream().map(Environment::getName).collect(Collectors.toList())));
        System.out.println("\nSucceeded: " + String.join((CharSequence)", ", succeeded));
        if (!failNames.isEmpty()) {
            System.err.println("Failed:");
            for (String failed : failNames) {
                List errors = (List)failures.get(failed);
                System.err.println("  " + failed + " (on " + errors.size() + " environments)");
                for (NonNullPair error : errors) {
                    System.err.println("    " + (String)error.getSecond() + " (on " + ((Environment)error.getFirst()).getName() + ")");
                }
            }
            System.exit(failNames.size());
        }
        System.out.printf("%n%s", StringUtils.repeat((String)"-", (int)60));
    }
}

