/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.slot;

import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.SlotWithIndex;
import java.util.Locale;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class EquipmentSlot
extends SlotWithIndex {
    private static final EquipSlot[] values = EquipSlot.values();
    private final EntityEquipment e;
    private final EquipSlot slot;
    private final boolean slotToString;

    public EquipmentSlot(EntityEquipment e, EquipSlot slot, boolean slotToString) {
        this.e = e;
        this.slot = slot;
        this.slotToString = slotToString;
    }

    public EquipmentSlot(EntityEquipment e, EquipSlot slot) {
        this(e, slot, false);
    }

    public EquipmentSlot(HumanEntity holder, int index) {
        this.e = holder.getEquipment();
        this.slot = values[41 - index];
        this.slotToString = true;
    }

    @Override
    public @Nullable ItemStack getItem() {
        return this.slot.get(this.e);
    }

    @Override
    public void setItem(@Nullable ItemStack item) {
        this.slot.set(this.e, item);
        if (this.e.getHolder() instanceof Player) {
            PlayerUtils.updateInventory((Player)this.e.getHolder());
        }
    }

    @Override
    public int getAmount() {
        ItemStack item = this.slot.get(this.e);
        return item != null ? item.getAmount() : 0;
    }

    @Override
    public void setAmount(int amount) {
        ItemStack item = this.slot.get(this.e);
        if (item != null) {
            item.setAmount(amount);
        }
        this.slot.set(this.e, item);
    }

    public EquipSlot getEquipSlot() {
        return this.slot;
    }

    @Override
    public int getIndex() {
        return this.slot.slotNumber;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.slotToString) {
            return "the " + this.slot.name().toLowerCase(Locale.ENGLISH) + " of " + Classes.toString(this.e.getHolder());
        }
        return Classes.toString(this.getItem());
    }

    public static enum EquipSlot {
        TOOL{

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getItemInMainHand();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setItemInMainHand(item);
            }
        }
        ,
        OFF_HAND(40){

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getItemInOffHand();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setItemInOffHand(item);
            }
        }
        ,
        HELMET(39){

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getHelmet();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setHelmet(item);
            }
        }
        ,
        CHESTPLATE(38){

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getChestplate();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setChestplate(item);
            }
        }
        ,
        LEGGINGS(37){

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getLeggings();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setLeggings(item);
            }
        }
        ,
        BOOTS(36){

            @Override
            public @Nullable ItemStack get(EntityEquipment e) {
                return e.getBoots();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setBoots(item);
            }
        };

        public final int slotNumber;

        private EquipSlot() {
            this.slotNumber = -1;
        }

        private EquipSlot(int number) {
            this.slotNumber = number;
        }

        public abstract @Nullable ItemStack get(EntityEquipment var1);

        public abstract void set(EntityEquipment var1, @Nullable ItemStack var2);
    }
}

