/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.util.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public abstract class VariablesStorage
implements Closeable {
    private static final int QUEUE_SIZE = 1000;
    private static final int FIRST_WARNING = 300;
    final LinkedBlockingQueue<SerializedVariable> changesQueue = new LinkedBlockingQueue(1000);
    protected volatile boolean closed = false;
    protected final String databaseName;
    protected @Nullable File file;
    private @Nullable Pattern variablePattern;
    private final Thread writeThread;
    protected final Object connectionLock = new Object();
    protected @Nullable Task backupTask = null;
    private long lastWarning = Long.MIN_VALUE;
    private static final int WARNING_INTERVAL = 10;
    private long lastError = Long.MIN_VALUE;
    private static final int ERROR_INTERVAL = 10;

    protected VariablesStorage(String name) {
        this.databaseName = name;
        this.writeThread = Skript.newThread(new Runnable(){

            @Override
            public void run() {
                while (!VariablesStorage.this.closed) {
                    try {
                        SerializedVariable var = VariablesStorage.this.changesQueue.take();
                        SerializedVariable.Value d = var.value;
                        if (d != null) {
                            VariablesStorage.this.save(var.name, d.type, d.data);
                            continue;
                        }
                        VariablesStorage.this.save(var.name, null, null);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "Skript variable save thread for database '" + name + "'");
    }

    protected @Nullable String getValue(SectionNode n, String key) {
        return this.getValue(n, key, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> @Nullable T getValue(SectionNode n, String key, Class<T> type) {
        String v = n.getValue(key);
        if (v == null) {
            Skript.error("The config is missing the entry for '" + key + "' in the database '" + this.databaseName + "'");
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T r = Classes.parse(v, type, ParseContext.CONFIG);
            if (r == null) {
                log.printError("The entry for '" + key + "' in the database '" + this.databaseName + "' must be " + Classes.getSuperClassInfo(type).getName().withIndefiniteArticle());
            } else {
                log.printLog();
            }
            T t = r;
            return t;
        }
        finally {
            log.stop();
        }
    }

    public final boolean load(SectionNode n) {
        String pattern = this.getValue(n, "pattern");
        if (pattern == null) {
            return false;
        }
        try {
            this.variablePattern = pattern.equals(".*") || pattern.equals(".+") ? null : Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Skript.error("Invalid pattern '" + pattern + "': " + e.getLocalizedMessage());
            return false;
        }
        if (this.requiresFile()) {
            Timespan backupInterval;
            File file;
            String f = this.getValue(n, "file");
            if (f == null) {
                return false;
            }
            this.file = file = this.getFile(f).getAbsoluteFile();
            if (file.exists() && !file.isFile()) {
                Skript.error("The database file '" + file.getName() + "' must be an actual file, not a directory.");
                return false;
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Skript.error("Cannot create the database file '" + file.getName() + "': " + e.getLocalizedMessage());
                return false;
            }
            if (!file.canWrite()) {
                Skript.error("Cannot write to the database file '" + file.getName() + "'!");
                return false;
            }
            if (!file.canRead()) {
                Skript.error("Cannot read from the database file '" + file.getName() + "'!");
                return false;
            }
            if (!"0".equals(this.getValue(n, "backup interval")) && (backupInterval = this.getValue(n, "backup interval", Timespan.class)) != null) {
                this.startBackupTask(backupInterval);
            }
        }
        if (!this.load_i(n)) {
            return false;
        }
        this.writeThread.start();
        Skript.closeOnDisable(this);
        return true;
    }

    protected abstract boolean load_i(SectionNode var1);

    protected abstract void allLoaded();

    protected abstract boolean requiresFile();

    protected abstract File getFile(String var1);

    protected abstract boolean connect();

    protected abstract void disconnect();

    public void startBackupTask(Timespan t) {
        final File file = this.file;
        if (file == null || t.getTicks_i() == 0L) {
            return;
        }
        this.backupTask = new Task((Plugin)Skript.getInstance(), t.getTicks_i(), t.getTicks_i(), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = VariablesStorage.this.connectionLock;
                synchronized (object) {
                    VariablesStorage.this.disconnect();
                    try {
                        FileUtils.backup(file);
                    }
                    catch (IOException e) {
                        Skript.error("Automatic variables backup failed: " + e.getLocalizedMessage());
                    }
                    finally {
                        VariablesStorage.this.connect();
                    }
                }
            }
        };
    }

    boolean accept(@Nullable String var) {
        if (var == null) {
            return false;
        }
        return this.variablePattern != null ? this.variablePattern.matcher(var).matches() : true;
    }

    final void save(SerializedVariable var) {
        if (this.changesQueue.size() > 300 && this.lastWarning < System.currentTimeMillis() - 10000L) {
            Skript.warning("Cannot write variables to the database '" + this.databaseName + "' at sufficient speed; server performance may suffer and many variables will be lost if the server crashes. (this warning will be repeated at most once every " + 10 + " seconds)");
            this.lastWarning = System.currentTimeMillis();
        }
        if (!this.changesQueue.offer(var)) {
            if (this.lastError < System.currentTimeMillis() - 10000L) {
                Skript.error("Skript cannot save any variables to the database '" + this.databaseName + "'. The server will hang and may crash if no more variables can be saved.");
                this.lastError = System.currentTimeMillis();
            }
            while (true) {
                try {
                    this.changesQueue.put(var);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void close() {
        while (this.changesQueue.size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closed = true;
        this.writeThread.interrupt();
    }

    protected void clearChangesQueue() {
        this.changesQueue.clear();
    }

    protected abstract boolean save(String var1, @Nullable String var2, @Nullable byte[] var3);
}

