/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ScriptAliases;
import ch.njol.skript.bukkitutil.CommandReloader;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.events.bukkit.PreScriptLoadEvent;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.While;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.variables.TypeHints;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.OpenCloseable;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptLoader {
    private static final Message m_no_errors = new Message("skript.no errors");
    private static final Message m_no_scripts = new Message("skript.no scripts");
    private static final PluralizingArgsMessage m_scripts_loaded = new PluralizingArgsMessage("skript.scripts loaded");
    private static final ScriptInfo loadedScripts = new ScriptInfo();
    private static final Map<String, Set<String>> commandNames = new HashMap<String, Set<String>>();
    private static final Set<File> loadedFiles = Collections.synchronizedSet(new HashSet());
    private static final FileFilter scriptFilter = f -> f != null && (f.isDirectory() || StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith("-");
    private static final Set<File> disabledFiles = Collections.synchronizedSet(new HashSet());
    private static final FileFilter disabledFilter = f -> f != null && (f.isDirectory() || StringUtils.endsWithIgnoreCase("" + f.getName(), ".sk")) && f.getName().startsWith("-");
    private static final BlockingQueue<Runnable> loadQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup asyncLoaderThreadGroup = new ThreadGroup("Skript async loaders");
    private static final List<AsyncLoaderThread> loaderThreads = new ArrayList<AsyncLoaderThread>();
    private static int asyncLoaderSize;

    static void disableScripts() {
        VariableString.variableNames.clear();
        SkriptEventHandler.removeAllTriggers();
        Commands.clearCommands();
        Functions.clearFunctions();
    }

    private static ParserInstance getParser() {
        return ParserInstance.get();
    }

    private static void updateDisabledScripts(Path path) {
        disabledFiles.clear();
        try {
            Files.walk(path, new FileVisitOption[0]).map(Path::toFile).filter(disabledFilter::accept).forEach(disabledFiles::add);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isAsync() {
        return asyncLoaderSize > 0;
    }

    public static boolean isParallel() {
        return asyncLoaderSize > 1;
    }

    public static void setAsyncLoaderSize(int size) throws IllegalStateException {
        asyncLoaderSize = size;
        if (size <= 0) {
            for (AsyncLoaderThread thread : loaderThreads) {
                thread.cancelExecution();
            }
            return;
        }
        while (loaderThreads.size() > size) {
            AsyncLoaderThread thread = loaderThreads.remove(loaderThreads.size() - 1);
            thread.cancelExecution();
        }
        while (loaderThreads.size() < size) {
            loaderThreads.add(AsyncLoaderThread.create());
        }
        if (loaderThreads.size() != size) {
            throw new IllegalStateException();
        }
    }

    private static <T> CompletableFuture<T> makeFuture(Supplier<T> supplier, OpenCloseable openCloseable) {
        CompletableFuture future = new CompletableFuture();
        Runnable task = () -> {
            try {
                Object t;
                openCloseable.open();
                try {
                    t = supplier.get();
                }
                finally {
                    openCloseable.close();
                }
                future.complete(t);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
                Skript.exception(t, new String[0]);
            }
        };
        if (ScriptLoader.isAsync() && Bukkit.isPrimaryThread()) {
            loadQueue.add(task);
        } else {
            task.run();
            assert (future.isDone());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompletableFuture<Void> loadScripts(OpenCloseable openCloseable) {
        List<Config> configs;
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        Date start = new Date();
        ScriptLoader.updateDisabledScripts(scriptsFolder.toPath());
        HashSet<File> oldLoadedFiles = new HashSet<File>(loadedFiles);
        CountingLogHandler logHandler = new CountingLogHandler(Level.SEVERE).start();
        try {
            Language.setUseLocal(false);
            configs = ScriptLoader.loadStructures(scriptsFolder);
        }
        finally {
            logHandler.stop();
        }
        return ((CompletableFuture)ScriptLoader.loadScripts(configs, OpenCloseable.combine(openCloseable, logHandler)).whenComplete((scriptInfo, throwable) -> Language.setUseLocal(true))).thenAccept(scriptInfo -> {
            if (logHandler.getCount() == 0) {
                Skript.info(m_no_errors.toString());
            }
            if (ScriptLoader.isAsync()) {
                oldLoadedFiles.removeAll(loadedFiles);
                for (File script : oldLoadedFiles) {
                    if (script == null) {
                        throw new NullPointerException();
                    }
                    ScriptLoader.unloadScript_(script);
                    String name = Skript.getInstance().getDataFolder().toPath().toAbsolutePath().resolve("scripts").relativize(script.toPath()).toString();
                    assert (name != null);
                    Functions.clearFunctions(name);
                }
                Functions.validateFunctions();
            }
            if (scriptInfo.files == 0) {
                Skript.warning(m_no_scripts.toString());
            }
            if (Skript.logNormal() && scriptInfo.files > 0) {
                Skript.info(m_scripts_loaded.toString(scriptInfo.files, scriptInfo.triggers, scriptInfo.commands, start.difference(new Date())));
            }
        });
    }

    public static CompletableFuture<ScriptInfo> loadScripts(List<Config> configs, OpenCloseable openCloseable) {
        AtomicBoolean syncCommands = new AtomicBoolean();
        boolean wasLocal = Language.setUseLocal(false);
        Bukkit.getPluginManager().callEvent((Event)new PreScriptLoadEvent(configs));
        ScriptInfo scriptInfo = new ScriptInfo();
        ArrayList<CompletableFuture<Void>> scriptInfoFutures = new ArrayList<CompletableFuture<Void>>();
        for (Config config : configs) {
            if (config == null) {
                throw new NullPointerException();
            }
            CompletableFuture<Void> future = ScriptLoader.makeFuture(() -> {
                ScriptInfo info = ScriptLoader.loadScript(config);
                if (!info.commandNames.equals(commandNames.get(config.getFileName()))) {
                    syncCommands.set(true);
                    commandNames.put(config.getFileName(), info.commandNames);
                }
                scriptInfo.add(info);
                return null;
            }, openCloseable);
            scriptInfoFutures.add(future);
        }
        return ((CompletableFuture)CompletableFuture.allOf(scriptInfoFutures.toArray(new CompletableFuture[0])).whenComplete((unused, throwable) -> {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        })).thenApply(unused -> {
            SkriptEventHandler.registerBukkitEvents();
            if (syncCommands.get()) {
                if (CommandReloader.syncCommands(Bukkit.getServer())) {
                    Skript.debug("Commands synced to clients");
                } else {
                    Skript.debug("Commands changed but not synced to clients (normal on 1.12 and older)");
                }
            } else {
                Skript.debug("Commands unchanged, not syncing them to clients");
            }
            return scriptInfo;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptInfo loadScript(@Nullable Config config) {
        if (config == null) {
            return new ScriptInfo();
        }
        ArrayList<ScriptCommand> commands = new ArrayList<ScriptCommand>();
        ArrayList<ParsedEventData> events = new ArrayList<ParsedEventData>();
        ScriptInfo scriptInfo = new ScriptInfo();
        scriptInfo.files = 1;
        try {
            if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                SkriptConfig.configs.add(config);
            }
            ScriptLoader.getParser().getCurrentOptions().clear();
            ScriptLoader.getParser().setCurrentScript(config);
            try (CountingLogHandler ignored = new CountingLogHandler(SkriptLogger.SEVERE).start();){
                for (Node cnode : config.getMainNode()) {
                    NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
                    if (!(cnode instanceof SectionNode)) {
                        Skript.error("invalid line - all code has to be put into triggers");
                        continue;
                    }
                    SectionNode node = (SectionNode)cnode;
                    String event = node.getKey();
                    if (event == null) continue;
                    if (event.equalsIgnoreCase("aliases")) {
                        node.convertToEntries(0, "=");
                        Iterator<Node> aliases = Aliases.createScriptAliases();
                        Aliases.setScriptAliases((ScriptAliases)((Object)aliases));
                        ((ScriptAliases)((Object)aliases)).parser.load(node);
                        continue;
                    }
                    if (event.equalsIgnoreCase("options")) {
                        node.convertToEntries(0);
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in options");
                                continue;
                            }
                            ScriptLoader.getParser().getCurrentOptions().put(n.getKey(), ((EntryNode)n).getValue());
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("variables")) {
                        node.convertToEntries(0, "=");
                        for (Node n : node) {
                            Object o;
                            String var;
                            if (!(n instanceof EntryNode)) {
                                Skript.error("Invalid line in variables section");
                                continue;
                            }
                            String name = n.getKey().toLowerCase(Locale.ENGLISH);
                            if (name.startsWith("{") && name.endsWith("}")) {
                                name = "" + name.substring(1, name.length() - 1);
                            }
                            if ((name = StringUtils.replaceAll((CharSequence)name, "%(.+)?%", arg_0 -> ScriptLoader.lambda$loadScript$8(var = name, arg_0))) == null) continue;
                            if (name.contains("%")) {
                                Skript.error("Invalid use of percent signs in variable name");
                                continue;
                            }
                            if (Variables.getVariable(name, null, false) != null) continue;
                            ParseLogHandler log = SkriptLogger.startParseLogHandler();
                            try {
                                o = Classes.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.SCRIPT);
                                if (o == null) {
                                    log.printError("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                                    continue;
                                }
                                log.printLog();
                            }
                            finally {
                                log.stop();
                                continue;
                            }
                            ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
                            if (ci.getSerializer() == null) {
                                Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                continue;
                            }
                            if (ci.getSerializeAs() != null) {
                                ClassInfo<?> as = Classes.getExactClassInfo(ci.getSerializeAs());
                                if (as == null) {
                                    assert (false) : ci;
                                    continue;
                                }
                                if ((o = Converters.convert(o, as.getC())) == null) {
                                    Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                    continue;
                                }
                            }
                            Variables.setVariable(name, o, null, false);
                        }
                        continue;
                    }
                    if (!SkriptParser.validateLine(event)) continue;
                    if (event.toLowerCase().startsWith("command ")) {
                        ScriptLoader.getParser().setCurrentEvent("command", CommandEvent.class);
                        ScriptCommand c = Commands.loadCommand(node, false);
                        if (c != null) {
                            commands.add(c);
                            scriptInfo.commandNames.add(c.getName());
                            ++scriptInfo.commands;
                        }
                        ScriptLoader.getParser().deleteCurrentEvent();
                        continue;
                    }
                    if (event.toLowerCase().startsWith("function ")) {
                        ScriptLoader.getParser().setCurrentEvent("function", FunctionEvent.class);
                        Function<?> func = Functions.loadFunction(node);
                        if (func != null) {
                            ++scriptInfo.functions;
                        }
                        ScriptLoader.getParser().deleteCurrentEvent();
                        continue;
                    }
                    if (Skript.logVeryHigh() && !Skript.debug()) {
                        Skript.info("loading trigger '" + event + "'");
                    }
                    if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                        event = "" + event.substring("on ".length());
                    }
                    if ((parsedEvent = SkriptParser.parseEvent(event = ScriptLoader.replaceOptions(event), "can't understand this event: '" + node.getKey() + "'")) == null || !parsedEvent.getSecond().shouldLoadEvent()) continue;
                    if (Skript.debug() || node.debug()) {
                        Skript.debug(event + " (" + parsedEvent.getSecond().toString(null, true) + "):");
                    }
                    try {
                        ScriptLoader.getParser().setCurrentEvent("" + parsedEvent.getFirst().getName().toLowerCase(Locale.ENGLISH), parsedEvent.getFirst().events);
                        ScriptLoader.getParser().setCurrentSkriptEvent(parsedEvent.getSecond());
                        events.add(new ParsedEventData(parsedEvent, event, node, ScriptLoader.loadItems(node)));
                    }
                    finally {
                        ScriptLoader.getParser().deleteCurrentEvent();
                        ScriptLoader.getParser().deleteCurrentSkriptEvent();
                    }
                    if (parsedEvent.getSecond() instanceof SelfRegisteringSkriptEvent) {
                        ((SelfRegisteringSkriptEvent)parsedEvent.getSecond()).afterParse(config);
                    }
                    ++scriptInfo.triggers;
                }
                if (Skript.logHigh()) {
                    Skript.info("loaded " + scriptInfo.triggers + " trigger" + (scriptInfo.triggers == 1 ? "" : "s") + " and " + scriptInfo.commands + " command" + (scriptInfo.commands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                }
                ScriptLoader.getParser().setCurrentScript(null);
                Aliases.setScriptAliases(null);
            }
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load " + config.getFileName());
        }
        finally {
            SkriptLogger.setNode(null);
        }
        Callable<Void> callable = () -> {
            File file = config.getFile();
            if (ScriptLoader.isAsync() && file != null) {
                ScriptLoader.unloadScript_(file);
            }
            for (ScriptCommand command : commands) {
                Commands.registerCommand(command);
            }
            for (ParsedEventData event : events) {
                Trigger trigger;
                ScriptLoader.getParser().setCurrentEvent("" + event.info.getFirst().getName().toLowerCase(Locale.ENGLISH), event.info.getFirst().events);
                ScriptLoader.getParser().setCurrentSkriptEvent(event.info.getSecond());
                try {
                    trigger = new Trigger(config.getFile(), event.event, event.info.getSecond(), event.items);
                    trigger.setLineNumber(event.node.getLine());
                    trigger.setDebugLabel(config.getFileName() + ": line " + event.node.getLine());
                }
                finally {
                    ScriptLoader.getParser().deleteCurrentEvent();
                }
                if (event.info.getSecond() instanceof SelfRegisteringSkriptEvent) {
                    ((SelfRegisteringSkriptEvent)event.info.getSecond()).register(trigger);
                    SkriptEventHandler.addSelfRegisteringTrigger(trigger);
                } else {
                    SkriptEventHandler.addTrigger(event.info.getFirst().events, trigger);
                }
                ScriptLoader.getParser().deleteCurrentEvent();
                ScriptLoader.getParser().deleteCurrentSkriptEvent();
            }
            File disabledFile = new File(file.getParentFile(), "-" + file.getName());
            disabledFiles.remove(disabledFile);
            loadedFiles.add(file);
            return null;
        };
        if (ScriptLoader.isAsync()) {
            Task.callSync(callable);
        } else {
            try {
                callable.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        return scriptInfo;
    }

    public static List<Config> loadStructures(File[] files) {
        Arrays.sort(files);
        ArrayList<Config> loadedFiles = new ArrayList<Config>(files.length);
        for (File f : files) {
            assert (f != null) : Arrays.toString(files);
            Config config = ScriptLoader.loadStructure(f);
            if (config == null) continue;
            loadedFiles.add(config);
        }
        return loadedFiles;
    }

    public static List<Config> loadStructures(File directory) {
        if (!directory.isDirectory()) {
            Config config = ScriptLoader.loadStructure(directory);
            return config != null ? Collections.singletonList(config) : Collections.emptyList();
        }
        Object[] files = directory.listFiles(scriptFilter);
        Arrays.sort(files);
        ArrayList<Config> loadedFiles = new ArrayList<Config>(files.length);
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                loadedFiles.addAll(ScriptLoader.loadStructures((File)file));
                continue;
            }
            Config cfg = ScriptLoader.loadStructure((File)file);
            if (cfg == null) continue;
            loadedFiles.add(cfg);
        }
        return loadedFiles;
    }

    @Nullable
    public static Config loadStructure(File f) {
        if (!f.exists()) {
            ScriptLoader.unloadScript(f);
            return null;
        }
        try {
            String name = Skript.getInstance().getDataFolder().toPath().toAbsolutePath().resolve("scripts").relativize(f.toPath().toAbsolutePath()).toString();
            assert (name != null);
            return ScriptLoader.loadStructure(new FileInputStream(f), name);
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    @Nullable
    public static Config loadStructure(InputStream source, String name) {
        try {
            Config config = new Config(source, name, Skript.getInstance().getDataFolder().toPath().resolve("scripts").resolve(name).toFile(), true, false, ":");
            return ScriptLoader.loadStructure(config);
        }
        catch (IOException e) {
            Skript.error("Could not load " + name + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Config loadStructure(Config config) {
        try {
            for (Node cnode : config.getMainNode()) {
                SectionNode node;
                String event;
                if (!(cnode instanceof SectionNode) || (event = (node = (SectionNode)cnode).getKey()) == null || !SkriptParser.validateLine(event) || !event.toLowerCase().startsWith("function ")) continue;
                ScriptLoader.getParser().setCurrentEvent("function", FunctionEvent.class);
                Functions.loadSignature(config.getFileName(), node);
                ScriptLoader.getParser().deleteCurrentEvent();
            }
            ScriptLoader.getParser().setCurrentScript(null);
            SkriptLogger.setNode(null);
            Config config2 = config;
            return config2;
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load " + config.getFileName());
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return null;
    }

    private static ScriptInfo unloadScripts_(File folder) {
        ScriptInfo info = new ScriptInfo();
        for (File f : folder.listFiles(scriptFilter)) {
            if (f.isDirectory()) {
                info.add(ScriptLoader.unloadScripts_(f));
                continue;
            }
            info.add(ScriptLoader.unloadScript_(f));
        }
        return info;
    }

    public static ScriptInfo unloadScript(File script) {
        ScriptInfo r = ScriptLoader.unloadScript_(script);
        Functions.validateFunctions();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptInfo unloadScript_(File script) {
        if (loadedFiles.contains(script)) {
            ScriptInfo info = SkriptEventHandler.removeTriggers(script);
            ScriptInfo scriptInfo = loadedScripts;
            synchronized (scriptInfo) {
                loadedScripts.subtract(info);
            }
            loadedFiles.remove(script);
            disabledFiles.add(new File(script.getParentFile(), "-" + script.getName()));
            String name = Skript.getInstance().getDataFolder().toPath().toAbsolutePath().resolve("scripts").relativize(script.toPath().toAbsolutePath()).toString();
            assert (name != null);
            Functions.clearFunctions(name);
            return info;
        }
        return new ScriptInfo();
    }

    public static CompletableFuture<ScriptInfo> reloadScript(File script, OpenCloseable openCloseable) {
        if (!ScriptLoader.isAsync()) {
            ScriptLoader.unloadScript_(script);
        }
        Config config = ScriptLoader.loadStructure(script);
        Functions.validateFunctions();
        if (config == null) {
            return CompletableFuture.completedFuture(new ScriptInfo());
        }
        return ScriptLoader.loadScripts(Collections.singletonList(config), openCloseable);
    }

    public static CompletableFuture<ScriptInfo> reloadScripts(File folder, OpenCloseable openCloseable) {
        if (!ScriptLoader.isAsync()) {
            ScriptLoader.unloadScripts_(folder);
        }
        List<Config> configs = ScriptLoader.loadStructures(folder);
        Functions.validateFunctions();
        return ScriptLoader.loadScripts(configs, openCloseable);
    }

    public static String replaceOptions(String s) {
        String r = StringUtils.replaceAll((CharSequence)s, "\\{@(.+?)\\}", m -> {
            String option = ScriptLoader.getParser().getCurrentOptions().get(m.group(1));
            if (option == null) {
                Skript.error("undefined option " + m.group());
                return m.group();
            }
            return Matcher.quoteReplacement(option);
        });
        assert (r != null);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            ScriptLoader.getParser().setIndentation(ScriptLoader.getParser().getIndentation() + "    ");
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Condition cond;
            String l;
            String name;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String s = ScriptLoader.replaceOptions("" + e.getKey());
                if (!SkriptParser.validateLine(s) || (stmt = Statement.parse(s, "Can't understand this condition/effect: " + s)) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                ScriptLoader.getParser().setHasDelayBefore(Kleenean.TRUE);
                continue;
            }
            if (!(n instanceof SectionNode) || !SkriptParser.validateLine(name = ScriptLoader.replaceOptions("" + n.getKey()))) continue;
            TypeHints.enterScope();
            if (StringUtils.startsWithIgnoreCase(name, "loop ")) {
                Expression<Object> loopedExpr;
                l = "" + name.substring("loop ".length());
                RetainingLogHandler h = SkriptLogger.startRetainingLog();
                try {
                    loopedExpr = new SkriptParser(l).parseExpression(Object.class);
                    if (loopedExpr != null) {
                        loopedExpr = loopedExpr.getConvertedExpression(Object.class);
                    }
                    if (loopedExpr == null) {
                        h.printErrors("Can't understand this loop: '" + name + "'");
                        continue;
                    }
                    h.printLog();
                }
                finally {
                    h.stop();
                    continue;
                }
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr + " because it's only a single value");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore = ScriptLoader.getParser().getHasDelayBefore();
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore != Kleenean.TRUE && ScriptLoader.getParser().getHasDelayBefore() != Kleenean.FALSE) {
                    ScriptLoader.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
                }
            } else if (StringUtils.startsWithIgnoreCase(name, "while ")) {
                l = "" + name.substring("while ".length());
                Condition c = Condition.parse(l, "Can't understand this condition: " + l);
                if (c == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + "while " + c.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore = ScriptLoader.getParser().getHasDelayBefore();
                items.add(new While(c, (SectionNode)n));
                if (hadDelayBefore != Kleenean.TRUE && ScriptLoader.getParser().getHasDelayBefore() != Kleenean.FALSE) {
                    ScriptLoader.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
                }
            } else if (name.equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else' has to be placed just after an 'if' or 'else if' section");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + "else:");
                }
                Kleenean hadDelayAfterLastIf = ScriptLoader.getParser().getHasDelayBefore();
                ScriptLoader.getParser().setHasDelayBefore(hadDelayBeforeLastIf);
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                ScriptLoader.getParser().setHasDelayBefore(hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(ScriptLoader.getParser().getHasDelayBefore())));
            } else if (StringUtils.startsWithIgnoreCase(name, "else if ")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    continue;
                }
                name = "" + name.substring("else if ".length());
                cond = Condition.parse(name, "can't understand this condition: '" + name + "'");
                if (cond == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + "else if " + cond.toString(null, true));
                }
                Kleenean hadDelayAfterLastIf = ScriptLoader.getParser().getHasDelayBefore();
                ScriptLoader.getParser().setHasDelayBefore(hadDelayBeforeLastIf);
                ((Conditional)items.get(items.size() - 1)).loadElseIf(cond, (SectionNode)n);
                ScriptLoader.getParser().setHasDelayBefore(hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(ScriptLoader.getParser().getHasDelayBefore().and(Kleenean.UNKNOWN))));
            } else {
                Kleenean hadDelayBefore;
                if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                    name = "" + name.substring(3);
                }
                if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(ScriptLoader.getParser().getIndentation() + cond.toString(null, true) + ":");
                }
                hadDelayBeforeLastIf = hadDelayBefore = ScriptLoader.getParser().getHasDelayBefore();
                items.add(new Conditional(cond, (SectionNode)n));
                ScriptLoader.getParser().setHasDelayBefore(hadDelayBefore.or(ScriptLoader.getParser().getHasDelayBefore().and(Kleenean.UNKNOWN)));
            }
            TypeHints.exitScope();
        }
        for (int i = 0; i < items.size() - 1; ++i) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            ScriptLoader.getParser().setIndentation("" + ScriptLoader.getParser().getIndentation().substring(0, ScriptLoader.getParser().getIndentation().length() - 4));
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static Trigger loadTrigger(SectionNode node) {
        NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
        String event = node.getKey();
        if (event == null) {
            assert (false) : node;
            return null;
        }
        if (event.toLowerCase().startsWith("on ")) {
            event = "" + event.substring("on ".length());
        }
        if ((parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getKey() + "'")) == null) {
            assert (false);
            return null;
        }
        ScriptLoader.getParser().setCurrentEvent("unit test", parsedEvent.getFirst().events);
        try {
            Trigger trigger = new Trigger(null, event, parsedEvent.getSecond(), ScriptLoader.loadItems(node));
            return trigger;
        }
        finally {
            ScriptLoader.getParser().deleteCurrentEvent();
        }
    }

    public static Collection<File> getLoadedFiles() {
        return Collections.unmodifiableCollection(loadedFiles);
    }

    public static Collection<File> getDisabledFiles() {
        return Collections.unmodifiableCollection(disabledFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadedFunctions() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    @Deprecated
    static void loadScripts() {
        if (!ScriptLoader.isAsync()) {
            ScriptLoader.disableScripts();
        }
        ScriptLoader.loadScripts(OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo loadScripts(List<Config> configs) {
        return ScriptLoader.loadScripts(configs, OpenCloseable.EMPTY).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ScriptInfo loadScripts(List<Config> configs, List<LogEntry> logOut) {
        RetainingLogHandler logHandler = new RetainingLogHandler();
        try {
            ScriptInfo scriptInfo = ScriptLoader.loadScripts(configs, logHandler).join();
            return scriptInfo;
        }
        finally {
            logOut.addAll(logHandler.getLog());
        }
    }

    @Deprecated
    public static ScriptInfo loadScripts(Config ... configs) {
        return ScriptLoader.loadScripts(Arrays.asList(configs), OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo reloadScript(File script) {
        return ScriptLoader.reloadScript(script, OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static ScriptInfo reloadScripts(File folder) {
        return ScriptLoader.reloadScripts(folder, OpenCloseable.EMPTY).join();
    }

    @Deprecated
    public static Kleenean getHasDelayBefore() {
        return ScriptLoader.getParser().getHasDelayBefore();
    }

    @Deprecated
    public static void setHasDelayBefore(Kleenean hasDelayBefore) {
        ScriptLoader.getParser().setHasDelayBefore(hasDelayBefore);
    }

    @Deprecated
    @Nullable
    public static Config getCurrentScript() {
        return ScriptLoader.getParser().getCurrentScript();
    }

    @Deprecated
    public static void setCurrentScript(@Nullable Config currentScript) {
        ScriptLoader.getParser().setCurrentScript(currentScript);
    }

    @Deprecated
    public static List<TriggerSection> getCurrentSections() {
        return ScriptLoader.getParser().getCurrentSections();
    }

    @Deprecated
    public static void setCurrentSections(List<TriggerSection> currentSections) {
        ScriptLoader.getParser().setCurrentSections(currentSections);
    }

    @Deprecated
    public static List<Loop> getCurrentLoops() {
        return ScriptLoader.getParser().getCurrentLoops();
    }

    @Deprecated
    public static void setCurrentLoops(List<Loop> currentLoops) {
        ScriptLoader.getParser().setCurrentLoops(currentLoops);
    }

    @Deprecated
    @Nullable
    public static String getCurrentEventName() {
        return ScriptLoader.getParser().getCurrentEventName();
    }

    @SafeVarargs
    @Deprecated
    public static void setCurrentEvent(String name, Class<? extends Event> ... events) {
        ScriptLoader.getParser().setCurrentEvent(name, events);
    }

    @Deprecated
    public static void deleteCurrentEvent() {
        ScriptLoader.getParser().deleteCurrentEvent();
    }

    @Deprecated
    public static boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return ScriptLoader.getParser().isCurrentEvent(event);
    }

    @SafeVarargs
    @Deprecated
    public static boolean isCurrentEvent(Class<? extends Event> ... events) {
        return ScriptLoader.getParser().isCurrentEvent(events);
    }

    @Deprecated
    @Nullable
    public static Class<? extends Event>[] getCurrentEvents() {
        return ScriptLoader.getParser().getCurrentEvents();
    }

    private static /* synthetic */ String lambda$loadScript$8(String var, Matcher m) {
        if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
            Skript.error("'" + var + "' is not a valid name for a default variable");
            return null;
        }
        ClassInfo<?> ci = Classes.getClassInfoFromUserInput("" + m.group(1));
        if (ci == null) {
            Skript.error("Can't understand the type '" + m.group(1) + "'");
            return null;
        }
        return "<" + ci.getCodeName() + ">";
    }

    private static class ParsedEventData {
        public final NonNullPair<SkriptEventInfo<?>, SkriptEvent> info;
        public final String event;
        public final SectionNode node;
        public final List<TriggerItem> items;

        public ParsedEventData(NonNullPair<SkriptEventInfo<?>, SkriptEvent> info, String event, SectionNode node, List<TriggerItem> items) {
            this.info = info;
            this.event = event;
            this.node = node;
            this.items = items;
        }
    }

    private static class AsyncLoaderThread
    extends Thread {
        private boolean shouldRun = true;

        public static AsyncLoaderThread create() {
            AsyncLoaderThread thread = new AsyncLoaderThread();
            thread.start();
            return thread;
        }

        private AsyncLoaderThread() {
            super(asyncLoaderThreadGroup, (Runnable)null);
        }

        @Override
        public void run() {
            while (this.shouldRun) {
                try {
                    Runnable runnable = (Runnable)loadQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (runnable == null) continue;
                    runnable.run();
                }
                catch (InterruptedException e) {
                    Skript.exception((Throwable)e, new String[0]);
                }
            }
        }

        public void cancelExecution() {
            this.shouldRun = false;
        }
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;
        public int functions;
        public final Set<String> commandNames;

        public ScriptInfo() {
            this.commandNames = new HashSet<String>();
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands, int numFunctions) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
            this.functions = numFunctions;
            this.commandNames = new HashSet<String>();
        }

        public ScriptInfo(ScriptInfo other) {
            this.files = other.files;
            this.triggers = other.triggers;
            this.commands = other.commands;
            this.functions = other.functions;
            this.commandNames = new HashSet<String>(other.commandNames);
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
            this.functions += other.functions;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
            this.functions -= other.functions;
        }

        public String toString() {
            return "ScriptInfo{files=" + this.files + ",triggers=" + this.triggers + ",commands=" + this.commands + ",functions:" + this.functions + "}";
        }
    }
}

