/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.iterator.EnumerationIterable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;

public final class SkriptAddon {
    public final JavaPlugin plugin;
    public final Version version;
    private final String name;
    @Nullable
    private String languageFileDirectory = null;
    @Nullable
    private File file = null;

    SkriptAddon(JavaPlugin p) {
        Version v;
        this.plugin = p;
        this.name = "" + p.getName();
        try {
            v = new Version("" + p.getDescription().getVersion());
        }
        catch (IllegalArgumentException e) {
            Matcher m = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?").matcher(p.getDescription().getVersion());
            if (!m.find()) {
                throw new IllegalArgumentException("The version of the plugin " + p.getName() + " does not contain any numbers: " + p.getDescription().getVersion());
            }
            v = new Version(Utils.parseInt("" + m.group(1)), m.group(2) == null ? 0 : Utils.parseInt("" + m.group(2)), m.group(3) == null ? 0 : Utils.parseInt("" + m.group(3)));
            Skript.warning("The plugin " + p.getName() + " uses a non-standard version syntax: '" + p.getDescription().getVersion() + "'. Skript will use " + v + " instead.");
        }
        this.version = v;
    }

    public final String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkriptAddon loadClasses(String basePackage, String ... subPackages) throws IOException {
        assert (subPackages != null);
        JarFile jar = new JarFile(this.getFile());
        for (int i = 0; i < subPackages.length; ++i) {
            subPackages[i] = subPackages[i].replace('.', '/') + "/";
        }
        basePackage = basePackage.replace('.', '/') + "/";
        try {
            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                if (!e.getName().startsWith(basePackage) || !e.getName().endsWith(".class")) continue;
                boolean load = subPackages.length == 0;
                for (String sub : subPackages) {
                    if (!e.getName().startsWith(sub, basePackage.length())) continue;
                    load = true;
                    break;
                }
                if (!load) continue;
                String c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                try {
                    Class.forName(c, true, this.plugin.getClass().getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    Skript.exception((Throwable)ex, "Cannot load class " + c + " from " + this);
                }
                catch (ExceptionInInitializerError err) {
                    Skript.exception(err.getCause(), this + "'s class " + c + " generated an exception while loading");
                }
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    public SkriptAddon setLanguageFileDirectory(String directory) {
        if (this.languageFileDirectory != null) {
            throw new IllegalStateException();
        }
        directory = "" + directory.replace('\\', '/');
        if (directory.endsWith("/")) {
            directory = "" + directory.substring(0, directory.length() - 1);
        }
        this.languageFileDirectory = directory;
        Language.loadDefault(this);
        return this;
    }

    @Nullable
    public String getLanguageFileDirectory() {
        return this.languageFileDirectory;
    }

    @Nullable
    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        try {
            Method getFile = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFile.setAccessible(true);
            this.file = (File)getFile.invoke((Object)this.plugin, new Object[0]);
            return this.file;
        }
        catch (NoSuchMethodException e) {
            Skript.outdatedError(e);
        }
        catch (IllegalArgumentException e) {
            Skript.outdatedError(e);
        }
        catch (IllegalAccessException e) {
            assert (false);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return null;
    }
}

