/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.command.Commands;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.util.NonNullPair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SkriptEventHandler {
    private static final PriorityListener[] listeners;
    private static final List<NonNullPair<Class<? extends Event>, Trigger>> triggers;
    private static final List<Trigger> selfRegisteredTriggers;
    private static long startEvent;
    private static long startTrigger;
    public static final Set<Class<? extends Event>> listenCancelled;

    private static Iterator<Trigger> getTriggers(Class<? extends Event> event) {
        return triggers.stream().filter(pair -> ((Class)pair.getFirst()).isAssignableFrom(event)).map(NonNullPair::getSecond).iterator();
    }

    private static void check(Event e, EventPriority priority) {
        Iterator<Trigger> ts = SkriptEventHandler.getTriggers(e.getClass());
        if (!ts.hasNext()) {
            return;
        }
        if (Skript.logVeryHigh()) {
            boolean hasTrigger = false;
            while (ts.hasNext()) {
                Trigger trigger = ts.next();
                if (trigger.getEvent().getEventPriority() != priority || !trigger.getEvent().check(e)) continue;
                hasTrigger = true;
                break;
            }
            if (!hasTrigger) {
                return;
            }
            Class<?> c = e.getClass();
            ts = SkriptEventHandler.getTriggers(c);
            SkriptEventHandler.logEventStart(e);
        }
        if (e instanceof Cancellable && ((Cancellable)e).isCancelled() && !listenCancelled.contains(e.getClass()) && (!(e instanceof PlayerInteractEvent) || ((PlayerInteractEvent)e).getAction() != Action.LEFT_CLICK_AIR && ((PlayerInteractEvent)e).getAction() != Action.RIGHT_CLICK_AIR || ((PlayerInteractEvent)e).useItemInHand() == Event.Result.DENY) || e instanceof ServerCommandEvent && (((ServerCommandEvent)e).getCommand().isEmpty() || ((ServerCommandEvent)e).isCancelled())) {
            if (Skript.logVeryHigh()) {
                Skript.info(" -x- was cancelled");
            }
            return;
        }
        while (ts.hasNext()) {
            Trigger t = ts.next();
            if (t.getEvent().getEventPriority() != priority || !t.getEvent().check(e)) continue;
            SkriptEventHandler.logTriggerStart(t);
            Object timing = SkriptTimings.start(t.getDebugLabel());
            t.execute(e);
            SkriptTimings.stop(timing);
            SkriptEventHandler.logTriggerEnd(t);
        }
        SkriptEventHandler.logEventEnd();
    }

    public static void logEventStart(Event e) {
        startEvent = System.nanoTime();
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("");
        Skript.info("== " + e.getClass().getName() + " ==");
    }

    public static void logEventEnd() {
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("== took " + 1.0 * (double)(System.nanoTime() - startEvent) / 1000000.0 + " milliseconds ==");
    }

    public static void logTriggerStart(Trigger t) {
        startTrigger = System.nanoTime();
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("# " + t.getName());
    }

    public static void logTriggerEnd(Trigger t) {
        if (!Skript.logVeryHigh()) {
            return;
        }
        Skript.info("# " + t.getName() + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
    }

    public static void addTrigger(Class<? extends Event>[] events, Trigger trigger) {
        for (Class<? extends Event> e : events) {
            triggers.add(new NonNullPair<Class<? extends Event>, Trigger>(e, trigger));
        }
    }

    public static void addSelfRegisteringTrigger(Trigger t) {
        assert (t.getEvent() instanceof SelfRegisteringSkriptEvent);
        selfRegisteredTriggers.add(t);
    }

    static ScriptLoader.ScriptInfo removeTriggers(File script) {
        ScriptLoader.ScriptInfo info = new ScriptLoader.ScriptInfo();
        info.files = 1;
        int previousSize = triggers.size();
        triggers.removeIf(pair -> script.equals(((Trigger)pair.getSecond()).getScript()));
        info.triggers += previousSize - triggers.size();
        for (int i = 0; i < selfRegisteredTriggers.size(); ++i) {
            Trigger t = selfRegisteredTriggers.get(i);
            if (!script.equals(t.getScript())) continue;
            ++info.triggers;
            ((SelfRegisteringSkriptEvent)t.getEvent()).unregister(t);
            selfRegisteredTriggers.remove(i);
            --i;
        }
        info.commands = Commands.unregisterCommands(script);
        return info;
    }

    static void removeAllTriggers() {
        triggers.clear();
        for (Trigger t : selfRegisteredTriggers) {
            ((SelfRegisteringSkriptEvent)t.getEvent()).unregisterAll();
        }
        selfRegisteredTriggers.clear();
    }

    static void registerBukkitEvents() {
        for (NonNullPair<Class<? extends Event>, Trigger> pair : triggers) {
            assert (pair.getFirst() != null);
            Class<? extends Event> e = pair.getFirst();
            EventPriority priority = pair.getSecond().getEvent().getEventPriority();
            PriorityListener listener = listeners[priority.ordinal()];
            EventExecutor executor = listener.executor;
            Set<Class<?>> registeredEvents = listener.registeredEvents;
            if (e.equals(PlayerInteractEntityEvent.class)) {
                if (registeredEvents.contains(e)) continue;
                registeredEvents.add(e);
                Bukkit.getPluginManager().registerEvent(e, (Listener)listener, priority, executor, (Plugin)Skript.getInstance());
                Bukkit.getPluginManager().registerEvent(PlayerInteractAtEntityEvent.class, (Listener)listener, priority, executor, (Plugin)Skript.getInstance());
                continue;
            }
            if (e.equals(PlayerInteractAtEntityEvent.class) || e.equals(PlayerArmorStandManipulateEvent.class) || SkriptEventHandler.containsSuperclass(registeredEvents, e)) continue;
            Bukkit.getPluginManager().registerEvent(e, (Listener)listener, priority, executor, (Plugin)Skript.getInstance());
            registeredEvents.add(e);
        }
    }

    public static boolean containsSuperclass(Set<Class<?>> classes, Class<?> c) {
        if (classes.contains(c)) {
            return true;
        }
        for (Class<?> cl : classes) {
            if (!cl.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    static {
        EventPriority[] priorities = EventPriority.values();
        listeners = new PriorityListener[priorities.length];
        for (int i = 0; i < priorities.length; ++i) {
            SkriptEventHandler.listeners[i] = new PriorityListener(priorities[i]);
        }
        triggers = new ArrayList<NonNullPair<Class<? extends Event>, Trigger>>();
        selfRegisteredTriggers = new ArrayList<Trigger>();
        listenCancelled = new HashSet<Class<? extends Event>>();
    }

    public static class PriorityListener
    implements Listener {
        public final EventPriority priority;
        public final Set<Class<? extends Event>> registeredEvents = new HashSet<Class<? extends Event>>();
        @Nullable
        private Event lastEvent;
        public final EventExecutor executor = (listener, event) -> {
            if (this.lastEvent == event) {
                return;
            }
            this.lastEvent = event;
            SkriptEventHandler.check(event, ((PriorityListener)listener).priority);
        };

        public PriorityListener(EventPriority priority) {
            this.priority = priority;
        }
    }
}

