/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.skript.hooks.biomes.BiomeHook;
import ch.njol.skript.hooks.biomes.BiomeMapUtil;
import ch.njol.skript.util.EnumUtils;
import org.bukkit.block.Biome;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BiomeMappings {
    private static final EnumUtils<Biome> util = new EnumUtils<Biome>(Biome.class, "biomes");
    private static final boolean mapFor19 = !Skript.isRunningMinecraft(1, 13);

    @Nullable
    public static Biome parse(String name) {
        if (!mapFor19) {
            return util.parse(name);
        }
        BiomeMapUtil.To19Mapping mapping = BiomeHook.getUtil().parse(name);
        if (mapping == null) {
            return util.parse(name);
        }
        return mapping.getHandle();
    }

    public static String toString(Biome biome, int flags) {
        if (!mapFor19) {
            return util.toString(biome, flags);
        }
        BiomeMapUtil.To19Mapping mapping = BiomeMapUtil.To19Mapping.getMapping(biome);
        if (mapping == null) {
            return "";
        }
        return BiomeHook.getUtil().toString(mapping, flags);
    }

    public static String getAllNames() {
        if (!mapFor19) {
            return util.getAllNames();
        }
        return BiomeHook.getUtil().getAllNames();
    }
}

