/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.eclipse.jdt.annotation.Nullable;

public class EnchantmentUtils {
    private static final boolean KEY_METHOD_EXISTS = Skript.methodExists(Enchantment.class, "getKey", new Class[0]);
    private static final BiMap<Enchantment, String> ENCHANTMENTS = HashBiMap.create();

    public static String getKey(Enchantment ench) {
        if (KEY_METHOD_EXISTS) {
            return ench.getKey().getKey();
        }
        String name = (String)ENCHANTMENTS.get((Object)ench);
        assert (name != null) : "missing name for " + ench;
        return name;
    }

    @Nullable
    public static Enchantment getByKey(String key) {
        if (KEY_METHOD_EXISTS) {
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key));
        }
        return (Enchantment)ENCHANTMENTS.inverse().get((Object)key);
    }

    static {
        ENCHANTMENTS.put((Object)Enchantment.PROTECTION_ENVIRONMENTAL, (Object)"protection");
        ENCHANTMENTS.put((Object)Enchantment.PROTECTION_FIRE, (Object)"fire_protection");
        ENCHANTMENTS.put((Object)Enchantment.PROTECTION_FALL, (Object)"feather_falling");
        ENCHANTMENTS.put((Object)Enchantment.PROTECTION_EXPLOSIONS, (Object)"blast_protection");
        ENCHANTMENTS.put((Object)Enchantment.PROTECTION_PROJECTILE, (Object)"projectile_protection");
        ENCHANTMENTS.put((Object)Enchantment.OXYGEN, (Object)"respiration");
        ENCHANTMENTS.put((Object)Enchantment.WATER_WORKER, (Object)"aqua_affinity");
        ENCHANTMENTS.put((Object)Enchantment.THORNS, (Object)"thorns");
        ENCHANTMENTS.put((Object)Enchantment.DEPTH_STRIDER, (Object)"depth_strider");
        ENCHANTMENTS.put((Object)Enchantment.DAMAGE_ALL, (Object)"sharpness");
        ENCHANTMENTS.put((Object)Enchantment.DAMAGE_UNDEAD, (Object)"smite");
        ENCHANTMENTS.put((Object)Enchantment.DAMAGE_ARTHROPODS, (Object)"bane_of_arthropods");
        ENCHANTMENTS.put((Object)Enchantment.KNOCKBACK, (Object)"knockback");
        ENCHANTMENTS.put((Object)Enchantment.FIRE_ASPECT, (Object)"fire_aspect");
        ENCHANTMENTS.put((Object)Enchantment.LOOT_BONUS_MOBS, (Object)"looting");
        ENCHANTMENTS.put((Object)Enchantment.DIG_SPEED, (Object)"efficiency");
        ENCHANTMENTS.put((Object)Enchantment.SILK_TOUCH, (Object)"silk_touch");
        ENCHANTMENTS.put((Object)Enchantment.DURABILITY, (Object)"unbreaking");
        ENCHANTMENTS.put((Object)Enchantment.LOOT_BONUS_BLOCKS, (Object)"fortune");
        ENCHANTMENTS.put((Object)Enchantment.ARROW_DAMAGE, (Object)"power");
        ENCHANTMENTS.put((Object)Enchantment.ARROW_KNOCKBACK, (Object)"punch");
        ENCHANTMENTS.put((Object)Enchantment.ARROW_FIRE, (Object)"flame");
        ENCHANTMENTS.put((Object)Enchantment.ARROW_INFINITE, (Object)"infinity");
        ENCHANTMENTS.put((Object)Enchantment.LUCK, (Object)"luck_of_the_sea");
        ENCHANTMENTS.put((Object)Enchantment.LURE, (Object)"lure");
        if (Skript.isRunningMinecraft(1, 9)) {
            ENCHANTMENTS.put((Object)Enchantment.FROST_WALKER, (Object)"frost_walker");
            ENCHANTMENTS.put((Object)Enchantment.MENDING, (Object)"mending");
        }
        if (Skript.isRunningMinecraft(1, 11)) {
            ENCHANTMENTS.put((Object)Enchantment.BINDING_CURSE, (Object)"binding_curse");
            ENCHANTMENTS.put((Object)Enchantment.VANISHING_CURSE, (Object)"vanishing_curse");
        }
        if (Skript.isRunningMinecraft(1, 12)) {
            ENCHANTMENTS.put((Object)Enchantment.SWEEPING_EDGE, (Object)"sweeping_edge");
        }
    }
}

