/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.Date;
import ch.njol.util.Math2;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.Calendar;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class DefaultFunctions {
    private static String str(double n) {
        return StringUtils.toString(n, 4);
    }

    static {
        Parameter[] numberParam = new Parameter[]{new Parameter<Number>("n", DefaultClasses.NUMBER, true, null)};
        Parameter[] numbersParam = new Parameter[]{new Parameter<Number>("ns", DefaultClasses.NUMBER, false, null)};
        Functions.registerFunction(new SimpleJavaFunction<Long>("floor", numberParam, DefaultClasses.LONG, true){

            public Long[] executeSimple(Object[][] params) {
                if (params[0][0] instanceof Long) {
                    return new Long[]{(Long)params[0][0]};
                }
                return new Long[]{Math2.floor(((Number)params[0][0]).doubleValue())};
            }
        }.description("Rounds a number down, i.e. returns the closest integer smaller than or equal to the argument.").examples("floor(2.34) = 2", "floor(2) = 2", "floor(2.99) = 2").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Long>("round", numberParam, DefaultClasses.LONG, true){

            public Long[] executeSimple(Object[][] params) {
                if (params[0][0] instanceof Long) {
                    return new Long[]{(Long)params[0][0]};
                }
                return new Long[]{Math2.round(((Number)params[0][0]).doubleValue())};
            }
        }.description("Rounds a number, i.e. returns the closest integer to the argument.").examples("round(2.34) = 2", "round(2) = 2", "round(2.99) = 3", "round(2.5) = 3").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Long>("ceil", numberParam, DefaultClasses.LONG, true){

            public Long[] executeSimple(Object[][] params) {
                if (params[0][0] instanceof Long) {
                    return new Long[]{(Long)params[0][0]};
                }
                return new Long[]{Math2.ceil(((Number)params[0][0]).doubleValue())};
            }
        }.description("Rounds a number up, i.e. returns the closest integer larger than or equal to the argument.").examples("ceil(2.34) = 3", "ceil(2) = 2", "ceil(2.99) = 3").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Long>("ceiling", numberParam, DefaultClasses.LONG, true){

            public Long[] executeSimple(Object[][] params) {
                if (params[0][0] instanceof Long) {
                    return new Long[]{(Long)params[0][0]};
                }
                return new Long[]{Math2.ceil(((Number)params[0][0]).doubleValue())};
            }
        }.description("Alias of <a href='#ceil'>ceil</a>.").examples("ceiling(2.34) = 3", "ceiling(2) = 2", "ceiling(2.99) = 3").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("abs", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Number n = (Number)params[0][0];
                if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
                    return new Long[]{Math.abs(n.longValue())};
                }
                return new Double[]{Math.abs(n.doubleValue())};
            }
        }.description("Returns the absolute value of the argument, i.e. makes the argument positive.").examples("abs(3) = 3", "abs(-2) = 2").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("mod", new Parameter[]{new Parameter<Number>("d", DefaultClasses.NUMBER, true, null), new Parameter<Number>("m", DefaultClasses.NUMBER, true, null)}, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Number d = (Number)params[0][0];
                Number m = (Number)params[1][0];
                double mm = m.doubleValue();
                if (mm == 0.0) {
                    return new Double[]{Double.NaN};
                }
                return new Double[]{Math2.mod(d.doubleValue(), mm)};
            }
        }.description("Returns the modulo of the given arguments, i.e. the remainder of the division <code>d/m</code>, where d and m are the arguments of this function.", "The returned value is always positive. Returns NaN (not a number) if the second argument is zero.").examples("mod(3, 2) = 1", "mod(256436, 100) = 36", "mod(-1, 10) = 9").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("exp", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.exp(((Number)params[0][0]).doubleValue())};
            }
        }.description("The exponential function. You probably don't need this if you don't know what this is.").examples("exp(0) = 1", "exp(1) = " + DefaultFunctions.str(Math.exp(1.0))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("ln", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.log(((Number)params[0][0]).doubleValue())};
            }
        }.description("The natural logarithm. You probably don't need this if you don't know what this is.", "Returns NaN (not a number) if the argument is negative.").examples("ln(1) = 0", "ln(exp(5)) = 5", "ln(2) = " + StringUtils.toString(Math.log(2.0), 4)).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("log", new Parameter[]{new Parameter<Number>("n", DefaultClasses.NUMBER, true, null), new Parameter<Integer>("base", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(10, false))}, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.log10(((Number)params[0][0]).doubleValue()) / Math.log10(((Number)params[1][0]).doubleValue())};
            }
        }.description("A logarithm, with base 10 if none is specified. This is the inverse operation to exponentiation (for positive bases only), i.e. <code>log(base ^ exponent, base) = exponent</code> for any positive number 'base' and any number 'exponent'.", "Another useful equation is <code>base ^ log(a, base) = a</code> for any numbers 'base' and 'a'.", "Please note that due to how numbers are represented in computers, these equations do not hold for all numbers, as the computed values may slightly differ from the correct value.", "Returns NaN (not a number) if any of the arguments are negative.").examples("log(100) = 2 # 10^2 = 100", "log(16, 2) = 4 # 2^4 = 16").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("sqrt", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.sqrt(((Number)params[0][0]).doubleValue())};
            }
        }.description("The square root, which is the inverse operation to squaring a number (for positive numbers only). This is the same as <code>(argument) ^ (1/2)</code> \u2013 other roots can be calculated via <code>number ^ (1/root)</code>, e.g. <code>set {_l} to {_volume}^(1/3)</code>.", "Returns NaN (not a number) if the argument is negative.").examples("sqrt(4) = 2", "sqrt(2) = " + DefaultFunctions.str(Math.sqrt(2.0)), "sqrt(-1) = " + DefaultFunctions.str(Math.sqrt(-1.0))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("sin", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.sin(Math.toRadians(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The sine function. It starts at 0\u00b0 with a value of 0, goes to 1 at 90\u00b0, back to 0 at 180\u00b0, to -1 at 270\u00b0 and then repeats every 360\u00b0. Uses degrees, not radians.").examples("sin(90) = 1", "sin(60) = " + DefaultFunctions.str(Math.sin(Math.toRadians(60.0)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("cos", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.cos(Math.toRadians(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The cosine function. This is basically the <a href='#sin'>sine</a> shifted by 90\u00b0, i.e. <code>cos(a) = sin(a + 90\u00b0)</code>, for any number a. Uses degrees, not radians.").examples("cos(0) = 1", "cos(90) = 0").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("tan", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.tan(Math.toRadians(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The tangent function. This is basically <code><a href='#sin'>sin</a>(arg)/<a href='#cos'>cos</a>(arg)</code>. Uses degrees, not radians.").examples("tan(0) = 0", "tan(45) = 1", "tan(89.99) = " + DefaultFunctions.str(Math.tan(Math.toRadians(89.99)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("asin", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.toDegrees(Math.asin(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The inverse of the <a href='#sin'>sine</a>, also called arcsin. Returns result in degrees, not radians. Only returns values from -90 to 90.").examples("asin(0) = 0", "asin(1) = 90", "asin(0.5) = " + DefaultFunctions.str(Math.toDegrees(Math.asin(0.5)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("acos", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.toDegrees(Math.acos(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The inverse of the <a href='#cos'>cosine</a>, also called arccos. Returns result in degrees, not radians. Only returns values from 0 to 180.").examples("acos(0) = 90", "acos(1) = 0", "acos(0.5) = " + DefaultFunctions.str(Math.toDegrees(Math.asin(0.5)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("atan", numberParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.toDegrees(Math.atan(((Number)params[0][0]).doubleValue()))};
            }
        }.description("The inverse of the <a href='#tan'>tangent</a>, also called arctan. Returns result in degrees, not radians. Only returns values from -90 to 90.").examples("atan(0) = 0", "atan(1) = 45", "atan(10000) = " + DefaultFunctions.str(Math.toDegrees(Math.atan(10000.0)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("atan2", new Parameter[]{new Parameter<Number>("x", DefaultClasses.NUMBER, true, null), new Parameter<Number>("y", DefaultClasses.NUMBER, true, null)}, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                return new Double[]{Math.toDegrees(Math.atan2(((Number)params[1][0]).doubleValue(), ((Number)params[0][0]).doubleValue()))};
            }
        }.description("Similar to <a href='#atan'>atan</a>, but requires two coordinates and returns values from -180 to 180.", "The returned angle is measured counterclockwise in a standard mathematical coordinate system (x to the right, y to the top).").examples("atan2(0, 1) = 0", "atan2(10, 0) = 90", "atan2(-10, 5) = " + DefaultFunctions.str(Math.toDegrees(Math.atan2(-10.0, 5.0)))).since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("sum", numbersParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Object[] ns = params[0];
                double sum = ((Number)ns[0]).doubleValue();
                for (int i = 1; i < ns.length; ++i) {
                    sum += ((Number)ns[i]).doubleValue();
                }
                return new Double[]{sum};
            }
        }.description("Sums a list of numbers.").examples("sum(1) = 1", "sum(2, 3, 4) = 9", "sum({some list variable::*})", "sum(2, {_v::*}, and the player's y-coordinate)").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("product", numbersParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Object[] ns = params[0];
                double product = ((Number)ns[0]).doubleValue();
                for (int i = 1; i < ns.length; ++i) {
                    product *= ((Number)ns[i]).doubleValue();
                }
                return new Double[]{product};
            }
        }.description("Calculates the product of a list of numbers.").examples("product(1) = 1", "product(2, 3, 4) = 24", "product({some list variable::*})", "product(2, {_v::*}, and the player's y-coordinate)").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("max", numbersParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Object[] ns = params[0];
                double max = ((Number)ns[0]).doubleValue();
                for (int i = 1; i < ns.length; ++i) {
                    double d = ((Number)ns[i]).doubleValue();
                    if (!(d > max) && !Double.isNaN(max)) continue;
                    max = d;
                }
                return new Double[]{max};
            }
        }.description("Returns the maximum number from a list of numbers.").examples("max(1) = 1", "max(1, 2, 3, 4) = 4", "max({some list variable::*})").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Number>("min", numbersParam, DefaultClasses.NUMBER, true){

            public Number[] executeSimple(Object[][] params) {
                Object[] ns = params[0];
                double min = ((Number)ns[0]).doubleValue();
                for (int i = 1; i < ns.length; ++i) {
                    double d = ((Number)ns[i]).doubleValue();
                    if (!(d < min) && !Double.isNaN(min)) continue;
                    min = d;
                }
                return new Double[]{min};
            }
        }.description("Returns the minimum number from a list of numbers.").examples("min(1) = 1", "min(1, 2, 3, 4) = 1", "min({some list variable::*})").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<World>("world", new Parameter[]{new Parameter<String>("name", DefaultClasses.STRING, true, null)}, DefaultClasses.WORLD, true){

            public World[] executeSimple(Object[][] params) {
                World[] worldArray;
                World w = Bukkit.getWorld((String)((String)params[0][0]));
                if (w == null) {
                    worldArray = new World[]{};
                } else {
                    World[] worldArray2 = new World[1];
                    worldArray = worldArray2;
                    worldArray2[0] = w;
                }
                return worldArray;
            }
        }).description("Gets a world from its name.").examples("set {_nether} to world(\"%{_world}%_nether\")").since("2.2");
        Functions.registerFunction(new SimpleJavaFunction<Location>("location", new Parameter[]{new Parameter<Number>("x", DefaultClasses.NUMBER, true, null), new Parameter<Number>("y", DefaultClasses.NUMBER, true, null), new Parameter<Number>("z", DefaultClasses.NUMBER, true, null), new Parameter<World>("world", DefaultClasses.WORLD, true, new EventValueExpression<World>(World.class)), new Parameter<Integer>("yaw", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true)), new Parameter<Integer>("pitch", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true))}, DefaultClasses.LOCATION, true){

            public Location[] executeSimple(Object[][] params) {
                World world = params[3].length == 1 ? (World)params[3][0] : (World)Bukkit.getWorlds().get(0);
                return new Location[]{new Location(world, ((Number)params[0][0]).doubleValue(), ((Number)params[1][0]).doubleValue(), ((Number)params[2][0]).doubleValue(), ((Number)params[4][0]).floatValue(), ((Number)params[5][0]).floatValue())};
            }
        }.description("Creates a location from a world and 3 coordinates, with an optional yaw and pitch.", "If for whatever reason the world is not found, it will fallback to the server's main world.").examples("location(0, 128, 0)", "location(player's x-coordinate, player's y-coordinate + 5, player's z-coordinate, player's world, 0, 90)", "location(0, 64, 0, world \"world_nether\")", "location(100, 110, -145, world(\"my_custom_world\"))").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Date>("date", new Parameter[]{new Parameter<Number>("year", DefaultClasses.NUMBER, true, null), new Parameter<Number>("month", DefaultClasses.NUMBER, true, null), new Parameter<Number>("day", DefaultClasses.NUMBER, true, null), new Parameter<Integer>("hour", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true)), new Parameter<Integer>("minute", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true)), new Parameter<Integer>("second", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true)), new Parameter<Integer>("millisecond", DefaultClasses.NUMBER, true, new SimpleLiteral<Integer>(0, true)), new Parameter<Double>("zone_offset", DefaultClasses.NUMBER, true, new SimpleLiteral<Double>(Double.NaN, true)), new Parameter<Double>("dst_offset", DefaultClasses.NUMBER, true, new SimpleLiteral<Double>(Double.NaN, true))}, DefaultClasses.DATE, true){
            private final int[] fields = new int[]{1, 2, 5, 11, 12, 13, 14, 15, 16};
            private final int[] offsets = new int[]{0, -1, 0, 0, 0, 0, 0, 0, 0};
            private final double[] scale = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 60000.0, 60000.0};
            private final double[] relations = new double[]{0.08333333333333333, 0.03333333333333333, 0.041666666666666664, 0.016666666666666666, 0.016666666666666666, 0.001, 0.0, 0.0, 0.0};
            {
                int length = this.getSignature().getMaxParameters();
                assert (this.fields.length == length && this.offsets.length == length && this.scale.length == length && this.relations.length == length);
            }

            public Date[] executeSimple(Object[][] params) {
                Calendar c = Calendar.getInstance();
                c.setLenient(true);
                double carry = 0.0;
                for (int i = 0; i < this.fields.length; ++i) {
                    int field = this.fields[i];
                    Number n = (Number)params[i][0];
                    double value = n.doubleValue() * this.scale[i] + (double)this.offsets[i] + carry;
                    int v = Math2.floorI(value);
                    carry = (value - (double)v) * this.relations[i];
                    c.set(field, v);
                }
                return new Date[]{new Date(c.getTimeInMillis(), c.getTimeZone())};
            }
        }.description("Creates a date from a year, month, and day, and optionally also from hour, minute, second and millisecond.", "A time zone and DST offset can be specified as well (in minutes), if they are left out the server's time zone and DST offset are used (the created date will not retain this information).").examples("date(2014, 10, 1) # 0:00, 1st October 2014", "date(1990, 3, 5, 14, 30) # 14:30, 5th May 1990", "date(1999, 12, 31, 23, 59, 59, 999, -3*60, 0) # almost year 2000 in parts of Brazil (-3 hours offset, no DST)").since("2.2"));
        Functions.registerFunction(new SimpleJavaFunction<Vector>("vector", new Parameter[]{new Parameter<Number>("x", DefaultClasses.NUMBER, true, null), new Parameter<Number>("y", DefaultClasses.NUMBER, true, null), new Parameter<Number>("z", DefaultClasses.NUMBER, true, null)}, DefaultClasses.VECTOR, true){

            public Vector[] executeSimple(Object[][] params) {
                return new Vector[]{new Vector(((Number)params[0][0]).doubleValue(), ((Number)params[1][0]).doubleValue(), ((Number)params[2][0]).doubleValue())};
            }
        }.description("Creates a new vector, which can be used with various expressions, effects and functions.").examples("vector(0, 0, 0)").since("2.2-dev23"));
        Functions.registerFunction(new SimpleJavaFunction<Long>("calcExperience", new Parameter[]{new Parameter<Long>("level", DefaultClasses.LONG, true, null)}, DefaultClasses.LONG, true){

            public Long[] executeSimple(Object[][] params) {
                long level = (Long)params[0][0];
                long exp = level <= 0L ? 0L : (level >= 1L && level <= 15L ? level * level + 6L * level : (level >= 16L && level <= 30L ? (long)((int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0)) : (long)((int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0))));
                return new Long[]{exp};
            }
        }.description("Calculates the total amount of experience needed to achieve given level from scratch in Minecraft.").since("2.2-dev32"));
        Functions.registerFunction(new SimpleJavaFunction<Color>("rgb", new Parameter[]{new Parameter<Long>("red", DefaultClasses.LONG, true, null), new Parameter<Long>("green", DefaultClasses.LONG, true, null), new Parameter<Long>("blue", DefaultClasses.LONG, true, null)}, DefaultClasses.COLOR, true){

            public ColorRGB[] executeSimple(Object[][] params) {
                Long red = (Long)params[0][0];
                Long green = (Long)params[1][0];
                Long blue = (Long)params[2][0];
                return CollectionUtils.array(new ColorRGB(red.intValue(), green.intValue(), blue.intValue()));
            }
        }).description("Returns a RGB color from the given red, green and blue parameters.").examples("dye player's leggings rgb(120, 30, 45)").since("2.5");
    }
}

