/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Comparators;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Contains")
@Description(value={"Checks whether an inventory contains an item, a text contains another piece of text, or a list (e.g. {list variable::*} or 'drops') contains another object."})
@Examples(value={"block contains 20 cobblestone", "player has 4 flint and 2 iron ingots", "{list::*} contains 5"})
@Since(value="1.0")
public class CondContains
extends Condition {
    private Expression<?> containers;
    private Expression<?> items;
    private boolean explicitSingle;
    private CheckType checkType;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.containers = exprs[0];
        this.items = exprs[1];
        this.explicitSingle = matchedPattern == 2 && parseResult.mark != 1 || this.containers.isSingle();
        this.checkType = matchedPattern <= 1 ? CheckType.INVENTORY : CheckType.UNKNOWN;
        this.setNegated(matchedPattern % 2 == 1);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean check(Event e) {
        block8: {
            block9: {
                checkType = this.checkType;
                containerValues = this.containers.getArray(e);
                itemValues = this.items.getArray(e);
                if (containerValues.length == 0 || itemValues.length == 0) {
                    return this.isNegated();
                }
                containersAnd = this.containers.getAnd();
                itemsAnd = this.items.getAnd();
                if (checkType != CheckType.UNKNOWN) break block8;
                if (!Arrays.stream(containerValues).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(Inventory.class))) break block9;
                checkType = CheckType.INVENTORY;
                break block8;
            }
            if (!this.explicitSingle) ** GOTO lbl-1000
            if (Arrays.stream(containerValues).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(String.class))) {
                checkType = CheckType.STRING;
            } else lbl-1000:
            // 2 sources

            {
                checkType = CheckType.OBJECTS;
            }
        }
        and = containersAnd;
        if (checkType == CheckType.INVENTORY) {
            checker = (Checker<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$check$1(java.lang.Object[] boolean java.lang.Object ), (Ljava/lang/Object;)Z)((Object[])itemValues, (boolean)itemsAnd);
        } else if (checkType == CheckType.STRING) {
            caseSensitive = SkriptConfig.caseSensitive.value();
            checker = (Checker<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$check$3(java.lang.Object[] boolean boolean java.lang.Object ), (Ljava/lang/Object;)Z)((Object[])itemValues, (boolean)caseSensitive, (boolean)itemsAnd);
        } else {
            if (!CondContains.$assertionsDisabled && checkType != CheckType.OBJECTS) {
                throw new AssertionError();
            }
            and = false;
            checker = (Checker<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$check$5(java.lang.Object[] boolean java.lang.Object ), (Ljava/lang/Object;)Z)((Object[])itemValues, (boolean)itemsAnd);
        }
        return SimpleExpression.check(containerValues, checker, this.isNegated(), and);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.containers.toString(e, debug) + (this.isNegated() ? " doesn't contain " : " contains ") + this.items.toString(e, debug);
    }

    private static /* synthetic */ boolean lambda$check$5(Object[] itemValues, boolean itemsAnd, Object o) {
        return SimpleExpression.check(itemValues, o1 -> Comparators.compare(o, o1) == Comparator.Relation.EQUAL, false, itemsAnd);
    }

    private static /* synthetic */ boolean lambda$check$3(Object[] itemValues, boolean caseSensitive, boolean itemsAnd, Object o) {
        String string = (String)o;
        return SimpleExpression.check(itemValues, o1 -> {
            if (o1 instanceof String) {
                return StringUtils.contains(string, (String)o1, caseSensitive);
            }
            return false;
        }, false, itemsAnd);
    }

    private static /* synthetic */ boolean lambda$check$1(Object[] itemValues, boolean itemsAnd, Object o) {
        Inventory inventory = (Inventory)o;
        return SimpleExpression.check(itemValues, o1 -> {
            if (o1 instanceof ItemType) {
                return ((ItemType)o1).isContainedIn((Iterable<ItemStack>)inventory);
            }
            if (o1 instanceof ItemStack) {
                return inventory.contains((ItemStack)o1);
            }
            if (o1 instanceof Inventory) {
                return Objects.equals(inventory, o1);
            }
            return false;
        }, false, itemsAnd);
    }

    static {
        Skript.registerCondition(CondContains.class, "%inventories% (has|have) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories% (doesn't|does not|do not|don't) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% contain[(1\u00a6s)] %itemtypes/strings/objects%", "%inventories/strings/objects% (doesn't|does not|do not|don't) contain %itemtypes/strings/objects%");
    }

    private static enum CheckType {
        STRING,
        INVENTORY,
        OBJECTS,
        UNKNOWN;

    }
}

