/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.PersistentDataUtils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Has Relational Variable")
@Description(value={"Checks whether the given relation variables are present on the given holders.", "See <a href='classes.html#persistentdataholder'>persistent data holder</a> for a list of all holders."})
@Examples(value={"player holds relational variable {isAdmin}", "player holds relational variable {oldNames::*}"})
@RequiredPlugins(value={"1.14 or newer"})
@Since(value="2.5")
public class CondHasRelationalVariable
extends Condition {
    private Expression<Object> holders;
    private ExpressionList<Variable<?>> variables;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ExpressionList<Object> exprList = exprs[1] instanceof ExpressionList ? (ExpressionList)exprs[1] : new ExpressionList<Object>(new Expression[]{exprs[1]}, Object.class, false);
        for (Expression expr : exprList.getExpressions()) {
            if (!(expr instanceof Variable)) {
                return false;
            }
            if (!((Variable)expr).isLocal()) continue;
            Skript.error("Setting a relational variable using a local variable is not supported. If you are trying to set a value temporarily, consider using metadata", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.variables = exprList;
        this.holders = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        for (Expression<Variable<?>> expr : this.variables.getExpressions()) {
            if (this.holders.check(e, holder -> PersistentDataUtils.has(((Variable)expr).getName().toString(e), holder), this.isNegated())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString(this, PropertyCondition.PropertyType.HAVE, e, debug, this.holders, "relational variable(s) " + this.variables.toString(e, debug));
    }
}

