/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;

@Name(value="Is Charged")
@Description(value={"Checks if a creeper is charged (powered)."})
@Examples(value={"if the last spawned creeper is charged:", "\tbroadcast \"A charged creeper is at %location of last spawned creeper%\""})
@Since(value="2.5")
public class CondIsCharged
extends PropertyCondition<LivingEntity> {
    @Override
    public boolean check(LivingEntity e) {
        if (e instanceof Creeper) {
            return ((Creeper)e).isPowered();
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "charged";
    }

    static {
        CondIsCharged.register(CondIsCharged.class, "(charged|powered)", "livingentities");
    }
}

