/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Whitelisted")
@Description(value={"Whether or not the server or a player is whitelisted."})
@Examples(value={"if server is whitelisted:", "if player is whitelisted"})
@Since(value="2.5.2")
public class CondIsWhitelisted
extends Condition {
    @Nullable
    private Expression<Player> player;
    private boolean isServer;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(parseResult.mark == 1);
        boolean bl = this.isServer = matchedPattern == 0;
        if (matchedPattern == 1) {
            this.player = exprs[0];
        }
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.isServer) {
            return Bukkit.hasWhitelist() == this.isNegated();
        }
        Player[] players = this.player.getAll(e);
        if (this.player.getAnd() && this.isNegated()) {
            for (Player player : players) {
                if (!player.isWhitelisted()) continue;
                return false;
            }
        } else if (this.player.getAnd()) {
            for (Player player : players) {
                if (player.isWhitelisted()) continue;
                return false;
            }
        } else {
            for (Player player : players) {
                if (!player.isWhitelisted()) continue;
                return !this.isNegated();
            }
        }
        return !this.isNegated();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (this.player.getSingle(e) != null ? "player" : "server") + (this.isNegated() ? "not" : "") + "  whitelisted";
    }

    static {
        Skript.registerCondition(CondIsWhitelisted.class, "[the] server (is|1\u00a6is(n't| not)) white[ ]listed", "%players% (is|are)(|1\u00a6(n't| not)) white[ ]listed");
    }
}

