/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Holding")
@Description(value={"Checks whether a player is holding a specific item. Cannot be used with endermen, use 'entity is [not] an enderman holding &lt;item type&gt;' instead."})
@Examples(value={"player is holding a stick", "victim isn't holding a sword of sharpness"})
@Since(value="1.0")
public class CondItemInHand
extends Condition {
    private Expression<LivingEntity> entities;
    private Expression<ItemType> types;
    private boolean offTool;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = exprs[0];
        this.types = exprs[1];
        if (Skript.isRunningMinecraft(1, 9)) {
            this.offTool = matchedPattern == 2 || matchedPattern == 3 || matchedPattern == 6 || matchedPattern == 7;
            this.setNegated(matchedPattern >= 4);
        } else {
            this.offTool = false;
            this.setNegated(matchedPattern >= 2);
        }
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.entities.check(e, en -> this.types.check(e, type -> {
            EntityEquipment equipment = en.getEquipment();
            if (equipment == null) {
                return false;
            }
            if (Skript.isRunningMinecraft(1, 9)) {
                return this.offTool ? type.isOfType(equipment.getItemInOffHand()) : type.isOfType(equipment.getItemInMainHand());
            }
            ItemStack itemInHand = equipment.getItemInHand();
            return type.isOfType(itemInHand);
        }), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.entities.toString(e, debug) + " " + (this.entities.isSingle() ? "is" : "are") + " holding " + this.types.toString(e, debug) + (this.offTool ? " in off-hand" : "");
    }

    static {
        if (Skript.isRunningMinecraft(1, 9)) {
            Skript.registerCondition(CondItemInHand.class, "[%livingentities%] ha(s|ve) %itemtypes% in [main] hand", "[%livingentities%] (is|are) holding %itemtypes% [in main hand]", "[%livingentities%] ha(s|ve) %itemtypes% in off[(-| )]hand", "[%livingentities%] (is|are) holding %itemtypes% in off[(-| )]hand", "[%livingentities%] (ha(s|ve) not|do[es]n't have) %itemtypes% in [main] hand", "[%livingentities%] (is not|isn't) holding %itemtypes% [in main hand]", "[%livingentities%] (ha(s|ve) not|do[es]n't have) %itemtypes% in off[(-| )]hand", "[%livingentities%] (is not|isn't) holding %itemtypes% in off[(-| )]hand");
        } else {
            Skript.registerCondition(CondItemInHand.class, "[%livingentities%] ha(s|ve) %itemtypes% in hand", "[%livingentities%] (is|are) holding %itemtypes% in hand", "[%livingentities%] (ha(s|ve) not|do[es]n't have) %itemtypes%", "[%livingentities%] (is not|isn't) holding %itemtypes%");
        }
    }
}

