/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Script Loaded")
@Description(value={"Check if the current script, or another script, is currently loaded."})
@Examples(value={"script is loaded", "script \"example.sk\" is loaded"})
@Since(value="2.2-dev31")
public class CondScriptLoaded
extends Condition {
    @Nullable
    private Expression<String> scripts;
    @Nullable
    private File currentScriptFile;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.scripts = exprs[0];
        this.setNegated(matchedPattern == 1);
        assert (this.getParser().getCurrentScript() != null);
        this.currentScriptFile = this.getParser().getCurrentScript().getFile();
        return true;
    }

    @Override
    public boolean check(Event e) {
        Expression<String> scripts = this.scripts;
        if (scripts == null) {
            return ScriptLoader.getLoadedFiles().contains(this.currentScriptFile);
        }
        return scripts.check(e, scriptName -> ScriptLoader.getLoadedFiles().contains(SkriptCommand.getScriptFromName(scriptName)), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        boolean isSingle;
        Expression<String> scripts = this.scripts;
        String scriptName = scripts == null ? "script" : (scripts.isSingle() ? "script" : "scripts " + scripts.toString(e, debug));
        boolean bl = isSingle = scripts == null || scripts.isSingle();
        if (isSingle) {
            return scriptName + (this.isNegated() ? " isn't" : " is") + " loaded";
        }
        return scriptName + (this.isNegated() ? " aren't" : " are") + " loaded";
    }

    static {
        Skript.registerCondition(CondScriptLoaded.class, "script[s] [%-strings%] (is|are) loaded", "script[s] [%-strings%] (isn't|is not|aren't|are not) loaded");
    }
}

