/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Callback;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.Nullable;

public class HTMLGenerator {
    private File template;
    private File output;
    private String skeleton;
    private static final AnnotatedComparator annotatedComparator = new AnnotatedComparator();
    private static final EventComparator eventComparator = new EventComparator();
    private static final ClassInfoComparator classInfoComparator = new ClassInfoComparator();
    private static final FunctionComparator functionComparator = new FunctionComparator();

    public HTMLGenerator(File templateDir, File outputDir) {
        this.template = templateDir;
        this.output = outputDir;
        this.skeleton = HTMLGenerator.readFile(new File(this.template + "/template.html"));
    }

    private static <T> Iterator<T> sortedIterator(Iterator<T> it, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, comparator);
        return list.iterator();
    }

    public void generate() {
        for (File f : this.template.listFiles()) {
            String name;
            if (f.getName().equals("css")) {
                File cssTo = new File(this.output + "/css");
                cssTo.mkdirs();
                for (File css : new File(this.template + "/css").listFiles()) {
                    HTMLGenerator.writeFile(new File(cssTo + "/" + css.getName()), HTMLGenerator.readFile(css));
                }
                continue;
            }
            if (f.isDirectory() || f.getName().endsWith("template.html") || f.getName().endsWith(".md")) continue;
            Skript.info("Creating documentation for " + f.getName());
            String content = HTMLGenerator.readFile(f);
            String page = f.getName().endsWith(".html") ? this.skeleton.replace("${content}", content) : content;
            page = page.replace("${skript.version}", Skript.getVersion().toString());
            page = page.replace("${pagename}", f.getName().replace(".html", ""));
            ArrayList replace = Lists.newArrayList();
            int include = page.indexOf("${include");
            while (include != -1) {
                int endIncl = page.indexOf("}", include);
                name = page.substring(include + 10, endIncl);
                replace.add(name);
                include = page.indexOf("${include", endIncl);
            }
            for (String name2 : replace) {
                String temp = HTMLGenerator.readFile(new File(this.template + "/templates/" + name2));
                page = page.replace("${include " + name2 + "}", temp);
            }
            int generate = page.indexOf("${generate");
            while (generate != -1) {
                int nextBracket = page.indexOf("}", generate);
                String[] genParams = page.substring(generate + 11, nextBracket).split(" ");
                String generated = "";
                String descTemp = HTMLGenerator.readFile(new File(this.template + "/templates/" + genParams[1]));
                String genType = genParams[0];
                if (genType.equals("expressions")) {
                    Iterator<ExpressionInfo<?, ?>> it = HTMLGenerator.sortedIterator(Skript.getExpressions(), annotatedComparator);
                    while (it.hasNext()) {
                        ExpressionInfo<?, ?> info = it.next();
                        assert (info != null);
                        if (info.c.getAnnotation(NoDoc.class) != null) continue;
                        String string = this.generateAnnotated(descTemp, info);
                        generated = generated + string;
                    }
                } else if (genType.equals("effects")) {
                    ArrayList<SyntaxElementInfo<? extends Effect>> effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(Skript.getEffects());
                    Collections.sort(effects, annotatedComparator);
                    for (SyntaxElementInfo syntaxElementInfo : effects) {
                        assert (syntaxElementInfo != null);
                        if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated = generated + this.generateAnnotated(descTemp, syntaxElementInfo);
                    }
                } else if (genType.equals("conditions")) {
                    ArrayList<SyntaxElementInfo<? extends Condition>> conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(Skript.getConditions());
                    Collections.sort(conditions, annotatedComparator);
                    for (SyntaxElementInfo syntaxElementInfo : conditions) {
                        assert (syntaxElementInfo != null);
                        if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated = generated + this.generateAnnotated(descTemp, syntaxElementInfo);
                    }
                } else if (genType.equals("events")) {
                    ArrayList events = new ArrayList(Skript.getEvents());
                    Collections.sort(events, eventComparator);
                    for (SkriptEventInfo skriptEventInfo : events) {
                        assert (skriptEventInfo != null);
                        if (skriptEventInfo.c.getAnnotation(NoDoc.class) != null) continue;
                        generated = generated + this.generateEvent(descTemp, skriptEventInfo);
                    }
                } else if (genType.equals("classes")) {
                    ArrayList classes = new ArrayList(Classes.getClassInfos());
                    Collections.sort(classes, classInfoComparator);
                    for (ClassInfo classInfo : classes) {
                        if (ClassInfo.NO_DOC.equals(classInfo.getDocName())) continue;
                        assert (classInfo != null);
                        generated = generated + this.generateClass(descTemp, classInfo);
                    }
                } else if (genType.equals("functions")) {
                    ArrayList functions = new ArrayList(Functions.getJavaFunctions());
                    Collections.sort(functions, functionComparator);
                    for (JavaFunction javaFunction : functions) {
                        assert (javaFunction != null);
                        generated = generated + this.generateFunction(descTemp, javaFunction);
                    }
                }
                page = page.replace(page.substring(generate, nextBracket + 1), generated);
                generate = page.indexOf("${generate", nextBracket);
            }
            name = f.getName();
            if (name.endsWith(".html")) {
                page = page.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                assert (page != null);
                page = HTMLGenerator.minifyHtml(page);
            }
            assert (page != null);
            HTMLGenerator.writeFile(new File(this.output + File.separator + name), page);
        }
    }

    private static String minifyHtml(String page) {
        int c;
        StringBuilder sb = new StringBuilder(page.length());
        boolean space = false;
        for (int i = 0; i < page.length(); i += Character.charCount(c)) {
            c = page.codePointAt(i);
            if (c == 10 || c == 32) {
                if (space) continue;
                sb.append(' ');
                space = true;
                continue;
            }
            space = false;
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    private static String handleIf(String desc, String start, boolean value) {
        int ifStart = desc.indexOf(start);
        while (ifStart != -1) {
            int ifEnd = desc.indexOf("${end}", ifStart);
            String data = desc.substring(ifStart + start.length() + 1, ifEnd);
            String before = desc.substring(0, ifStart);
            String after = desc.substring(ifEnd + 6);
            desc = value ? before + data + after : before + after;
            ifStart = desc.indexOf(start, ifEnd);
        }
        return desc;
    }

    private String generateAnnotated(String descTemp, SyntaxElementInfo<?> info) {
        Class c = info.c;
        String desc = "";
        Name name = c.getAnnotation(Name.class);
        desc = descTemp.replace("${element.name}", name == null ? "Unknown Name" : name.value());
        Since since = c.getAnnotation(Since.class);
        desc = desc.replace("${element.since}", since == null ? "unknown" : since.value());
        Description description = c.getAnnotation(Description.class);
        desc = desc.replace("${element.desc}", description == null ? "missing description" : Joiner.on((String)"\n").join((Object[])description.value()).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", description == null ? "missing description" : Joiner.on((String)"\n").join((Object[])description.value()).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Examples examples = c.getAnnotation(Examples.class);
        desc = desc.replace("${element.examples}", examples == null ? "no examples available" : Joiner.on((String)"<br>").join((Object[])examples.value()));
        desc = desc.replace("${element.examples-safe}", examples == null ? "no examples available" : Joiner.on((String)"\\n").join((Object[])examples.value()).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.c.getSimpleName());
        Events events = c.getAnnotation(Events.class);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", events != null);
        if (events != null) {
            String[] eventNames = events.value();
            Object[] eventLinks = new String[eventNames.length];
            for (int i = 0; i < eventNames.length; ++i) {
                String eventName = eventNames[i];
                eventLinks[i] = "<a href=\"events.html#" + eventName + "\">" + eventName + "</a>";
            }
            desc = desc.replace("${element.events}", Joiner.on((String)", ").join(eventLinks));
        }
        desc = desc.replace("${element.events-safe}", events == null ? "" : Joiner.on((String)", ").join((Object[])events.value()));
        RequiredPlugins plugins = c.getAnnotation(RequiredPlugins.class);
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", plugins != null);
        desc = desc.replace("${element.required-plugins}", plugins == null ? "" : Joiner.on((String)", ").join((Object[])plugins.value()));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            for (String line : info.patterns) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = patterns + parsed;
            }
            String toReplace = "${generate element.patterns " + split[1] + "}";
            desc = desc.replace(toReplace, patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateEvent(String descTemp, SkriptEventInfo<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getId());
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            for (String line : info.patterns) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = patterns + parsed;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateClass(String descTemp, ClassInfo<?> info) {
        String desc = "";
        String docName = info.getDocName();
        desc = descTemp.replace("${element.name}", docName == null ? "Unknown Name" : docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description).replace("\n\n", "<p>"));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getCodeName());
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] lines = info.getUsage();
            if (lines == null) continue;
            for (String line : lines) {
                assert (line != null);
                line = HTMLGenerator.cleanPatterns(line);
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = patterns + parsed;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private String generateFunction(String descTemp, JavaFunction<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        desc = desc.replace("${element.desc-safe}", Joiner.on((String)"\\n").join(description == null ? new String[]{} : description).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        desc = desc.replace("${element.examples-safe}", Joiner.on((String)"\\n").join(examples == null ? new String[]{} : examples).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "    "));
        desc = desc.replace("${element.id}", info.getName());
        assert (desc != null);
        desc = HTMLGenerator.handleIf(desc, "${if events}", false);
        desc = HTMLGenerator.handleIf(desc, "${if required-plugins}", false);
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = HTMLGenerator.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            Parameter<?>[] params = info.getParameters();
            Object[] types = new String[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = params[i].toString();
            }
            String line = docName + "(" + Joiner.on((String)", ").join(types) + ")";
            patterns = patterns + pattern.replace("${element.pattern}", line);
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
            desc = desc.replace("${generate element.patterns-safe " + split[1] + "}", patterns.replace("\\", "\\\\"));
        }
        assert (desc != null);
        return desc;
    }

    private static String readFile(File f) {
        try {
            return Files.toString((File)f, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void writeFile(File f, String data) {
        try {
            Files.write((CharSequence)data, (File)f, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String cleanPatterns(String patterns) {
        String s = StringUtils.replaceAll((CharSequence)("" + Documentation.escapeHTML(patterns).replaceAll("(?<=[\\(\\|])[-0-9]+?\u00a6", "").replace("()", "").replaceAll("\\(([^|]+?)\\|\\)", "[$1]").replaceAll("\\(\\|([^|]+?)\\)", "[$1]").replaceAll("\\((.+?)\\|\\)", "[($1)]").replaceAll("\\(\\|(.+?)\\)", "[($1)]")), "(?<!\\\\)%(.+?)(?<!\\\\)%", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                int a;
                String s = m.group(1);
                if (s.startsWith("-")) {
                    s = s.substring(1);
                }
                String flag = "";
                if (s.startsWith("*") || s.startsWith("~")) {
                    flag = s.substring(0, 1);
                    s = s.substring(1);
                }
                if ((a = s.indexOf("@")) != -1) {
                    s = s.substring(0, a);
                }
                StringBuilder b = new StringBuilder("%");
                b.append(flag);
                boolean first = true;
                for (String c : s.split("/")) {
                    assert (c != null);
                    if (!first) {
                        b.append("/");
                    }
                    first = false;
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(c);
                    ClassInfo<?> ci = Classes.getClassInfoNoError(p.getFirst());
                    if (ci != null && ci.getDocName() != null && ci.getDocName() != ClassInfo.NO_DOC) {
                        b.append("<a href='classes.html#").append(p.getFirst()).append("'>").append(ci.getName().toString(p.getSecond())).append("</a>");
                        continue;
                    }
                    b.append(c);
                    if (ci == null || ci.getDocName() == ClassInfo.NO_DOC) continue;
                    Skript.warning("Used class " + p.getFirst() + " has no docName/name defined");
                }
                return "" + b.append("%").toString();
            }
        });
        assert (s != null) : patterns;
        return s;
    }

    private static class FunctionComparator
    implements Comparator<JavaFunction<?>> {
        @Override
        public int compare(@Nullable JavaFunction<?> o1, @Nullable JavaFunction<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class ClassInfoComparator
    implements Comparator<ClassInfo<?>> {
        @Override
        public int compare(@Nullable ClassInfo<?> o1, @Nullable ClassInfo<?> o2) {
            String name2;
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            String name1 = o1.getDocName();
            if (name1 == null) {
                name1 = o1.getCodeName();
            }
            if ((name2 = o2.getDocName()) == null) {
                name2 = o2.getCodeName();
            }
            return name1.compareTo(name2);
        }
    }

    private static class EventComparator
    implements Comparator<SkriptEventInfo<?>> {
        @Override
        public int compare(@Nullable SkriptEventInfo<?> o1, @Nullable SkriptEventInfo<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            if (o1.c.getAnnotation(NoDoc.class) != null) {
                return 1;
            }
            if (o2.c.getAnnotation(NoDoc.class) != null) {
                return -1;
            }
            return o1.name.compareTo(o2.name);
        }
    }

    private static class AnnotatedComparator
    implements Comparator<SyntaxElementInfo<?>> {
        @Override
        public int compare(@Nullable SyntaxElementInfo<?> o1, @Nullable SyntaxElementInfo<?> o2) {
            if (o1 == null || o2 == null) {
                assert (false);
                throw new NullPointerException();
            }
            if (o1.c.getAnnotation(NoDoc.class) != null) {
                if (o2.c.getAnnotation(NoDoc.class) != null) {
                    return 0;
                }
                return 1;
            }
            if (o2.c.getAnnotation(NoDoc.class) != null) {
                return -1;
            }
            Name name1 = o1.c.getAnnotation(Name.class);
            Name name2 = o2.c.getAnnotation(Name.class);
            if (name1 == null) {
                throw new SkriptAPIException("Name annotation expected: " + o1.c);
            }
            if (name2 == null) {
                throw new SkriptAPIException("Name annotation expected: " + o2.c);
            }
            return name1.value().compareTo(name2.value());
        }
    }
}

