/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server. Only formatting options supported by console", "(i.e. colors) are supported. If you need to use advanced chat formatting, send the", "message to all players instead of broadcasting it."})
@Examples(value={"broadcast \"Welcome %player% to the server!\"", "broadcast \"Woah! It's a message!\""})
@Since(value="1.0, 2.6 (broadcasting objects)")
public class EffBroadcast
extends Effect {
    private Expression<?> messages;
    @Nullable
    private Expression<World> worlds;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = LiteralUtils.defendExpression(exprs[0]);
        this.worlds = exprs[1];
        return LiteralUtils.canInitSafely(this.messages);
    }

    @Override
    public void execute(Event e) {
        World[] worlds = this.worlds != null ? this.worlds.getArray(e) : null;
        for (Object object : this.messages.getArray(e)) {
            String string;
            String string2 = string = object instanceof String ? (String)object : Classes.toString(object);
            if (worlds == null) {
                for (Player player : PlayerUtils.getOnlinePlayers()) {
                    player.sendMessage(string);
                }
                Bukkit.getConsoleSender().sendMessage(string);
                continue;
            }
            for (World w : worlds) {
                for (Player player : w.getPlayers()) {
                    player.sendMessage(string);
                }
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "broadcast " + this.messages.toString(e, debug) + (this.worlds == null ? "" : " to " + this.worlds.toString(e, debug));
    }

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %objects% [(to|in) %-worlds%]");
    }
}

